% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/combine-method.R
\name{combine-method}
\alias{combine-method}
\alias{combine,BSData,BSData-method}
\alias{combine}
\alias{combine,BSDMCs,BSDMCs-method}
\title{combine method}
\usage{
combine(obj1, obj2)

\S4method{combine}{BSData,BSData}(obj1, obj2)

\S4method{combine}{BSDMCs,BSDMCs}(obj1, obj2)
}
\arguments{
\item{obj1}{A \code{\link{BSData-class}} or \code{\link{BSDMCs-class}}}

\item{obj2}{A \code{\link{BSData-class}} or \code{\link{BSDMCs-class}}}
}
\value{
A \code{\link{BSData-class}} or \code{\link{BSDMCs-class}}
}
\description{
combine two \code{\link{BSData-class}} or
two \code{\link{BSDMCs-class}}
}
\examples{
set.seed(1980)
nr <- 150; nc <- 8
metht <- matrix(as.integer(runif(nr * nc*2, 0, nr)), nr)
methc <- matrix(rbinom(n=nr*nc,c(metht),prob = runif(nr*nc*2)),nr,nc*2)
r1 <- GRanges(rep('chr1', nr), IRanges(1:nr, width=1), strand='*')
names(r1) <- 1:nr
cd1 <- DataFrame(Group=rep('G1',each=nc),row.names=LETTERS[1:nc])
OBJ1 <- cBSData(rowRanges=r1,methReads=methc[,1:nc],totalReads=metht[,1:nc],
colData=cd1)
cd2 <- DataFrame(Group=rep('G2',each=nc),row.names=LETTERS[nc+1:nc])
OBJ2 <- cBSData(rowRanges=r1,methReads=methc[,nc+1:nc],totalReads=
metht[,nc+1:nc],colData=cd2)
OBJ3 <- combine(OBJ1, OBJ2)
OBJ3
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
