% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/cBSData-method.R
\name{cBSData-method}
\alias{cBSData-method}
\alias{cBSData,matrix,matrix,GRanges-method}
\alias{cBSData}
\title{cBSData method}
\usage{
cBSData(
  methReads,
  totalReads,
  rowRanges,
  colData = DataFrame(row.names = colnames(methReads)),
  metadata = list(),
  ...
)

\S4method{cBSData}{matrix,matrix,GRanges}(
  methReads,
  totalReads,
  rowRanges,
  colData = DataFrame(row.names = colnames(methReads)),
  metadata = list(),
  ...
)
}
\arguments{
\item{methReads}{The matrix \code{methReads} contains the number of
methylated reads spanning a CpG-site. The rows represent the CpG sites in
\code{rowRanges} and the columns represent the samples in \code{colData}.}

\item{totalReads}{The matrix \code{totalReads} contains the number of reads
spanning a CpG-site. The rows represent the CpG sites in \code{rowRanges}
and the columns represent the samples in \code{colData}.}

\item{rowRanges}{A \code{\link{GRanges}} or \code{\link{GRangesList}}
object describing the ranges of interest. Names, if present, become the row
names of the \code{\link{SummarizedExperiment}} object. The length of the
\code{\link{GRanges}} or \code{\link{GRangesList}} must equal the number of
rows of the matrices in \code{assays}. If \code{rowRanges} is missing, a
\code{\link{SummarizedExperiment}} instance is returned.}

\item{colData}{Object of class \code{"DataFrame"} containing information on
variable values of the samples}

\item{metadata}{An optional \code{list} of arbitrary content describing the
overall experiment}

\item{...}{other possible parameters}
}
\value{
A \code{\link{BSData-class}} object
}
\description{
Creates a \code{\link{BSData-class}} object
}
\details{
The rows of a \code{BSData} object represent ranges (in genomic
coordinates) of interest. The ranges of interest are described by a
\code{GRanges} or a \code{GRangesList} object,
accessible using the \code{rowRanges} function.
The \code{GRanges} and \code{GRangesList} classes
contains sequence (e.g., chromosome) name, genomic coordinates, and strand
information. Each range can be annotated with additional data; this data
might be used to describe the range or to
summarize results (e.g., statistics of differential abundance) relevant to
the range. Rows may or may not have row names; they often will not.
}
\examples{
nr <- 150; nc <- 8
metht <- matrix(as.integer(runif(nr * nc, 0, 100)), nr)
methc <- matrix(rbinom(n=nr*nc,c(metht),prob = runif(nr*nc)),nr,nc)
r1 <- GRanges(rep('chr1', nr), IRanges(1:nr, width=1), strand='*')
names(r1) <- 1:nr
cd1 <- DataFrame(Group=rep(c('G1','G2'),each=nc/2),row.names=LETTERS[1:nc])
OBJ1 <- cBSData(rowRanges=r1,methReads=methc,totalReads=metht,colData=cd1)
OBJ1
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
