% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{params}
\alias{params}
\title{params}
\arguments{
\item{methReads}{The matrix \code{methReads} contains the number of
methylated reads spanning a CpG-site. The rows represent the CpG sites in
\code{rowRanges} and the columns represent the samples in \code{colData}.}

\item{totalReads}{The matrix \code{totalReads} contains the number of reads
spanning a CpG-site. The rows represent the CpG sites in \code{rowRanges}
and the columns represent the samples in \code{colData}.}

\item{methLevels}{The matrix \code{methLevels} contains the predicted
methylation level spanning a CpG-site using Bayesian functional regression
models. The rows represent the CpG sites in \code{rowRanges} and the columns
represent the samples in \code{colData}.}

\item{rowRanges}{A \code{\link{GRanges}} or \code{\link{GRangesList}}
object describing the ranges of interest. Names, if present, become the row
names of the \code{\link{SummarizedExperiment}} object. The length of the
\code{\link{GRanges}} or \code{\link{GRangesList}} must equal the number of
rows of the matrices in \code{assays}. If \code{rowRanges} is missing, a
\code{\link{SummarizedExperiment}} instance is returned.}

\item{colData}{Object of class \code{'DataFrame'} containing information on
variable values of the samples}

\item{metadata}{A \code{list} of storing MCMC samples or DMCs}

\item{object}{A \code{\link{BSDMC-class}}
object}

\item{value}{An integer matrix}

\item{name}{A character list}

\item{obj1}{A \code{\link{BSDMC-class}}}

\item{obj2}{A \code{\link{BSDMC-class}}}

\item{files}{A character list}

\item{file}{A character}

\item{nCores}{An integer value specifying the number of machine cores for
parallel computing}

\item{mc.cores}{An integer greater than 0}

\item{pSize}{An integer value specifying the number of cytosines in a regrion
to be used in a Bayesian functiona regression model for DMC detection}

\item{bwa}{An integer value specifying the band-width size of B-spline basis
matrix for a natural cubic spline for the group-specific effects of the
Bayesian functional regression model}

\item{bwb}{An integer value specifying the band-width size of B-spline basis
matrix for a natural cubic spline for the individual-specific effects of the
Bayesian functional regression model}

\item{nBurn}{An integer value specifying the number of burn-in samples}

\item{nThin}{An integer value specifying the thining number in MCMC}

\item{nMC}{An integer value specifying the number of MCMC samples after
burn-in}

\item{sdv}{An double value specifying the standard deviation of priors}

\item{alpha}{A numeric value specifying the level of \eqn{\alpha} in credible
interval \eqn{(1-\alpha)\%}}

\item{col}{A character vector indicating which colors to alternate.}

\item{sfiles}{A logical value indicating whether files to be saved or not.}

\item{region}{An integer vector of length two specifying which subset of the
object to be plotted}

\item{nSplit}{A integer value specifying the number of subsets must be done
for plotting the results of DMC identification}

\item{parList}{A list specifying plots parameters, see \code{\link{par}}}

\item{...}{other possible parameters}
}
\description{
parameters name and their descriptions
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
