% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEtype.R
\name{DEtype}
\alias{DEtype}
\title{DEtype: Classifying differentially expressed genes from DEsingle}
\usage{
DEtype(results, threshold)
}
\arguments{
\item{results}{A output data frame from \code{DEsingle}, which contains the unclassified differential expression analysis results.}

\item{threshold}{A number of (0,1) to specify the threshold of FDR.}
}
\value{
A data frame containing the differential expression (DE) analysis results and DE gene types and states.
\itemize{
  \item theta_1, theta_2, mu_1, mu_2, size_1, size_2, prob_1, prob_2: MLE of the zero-inflated negative binomial distribution's parameters of group 1 and group 2.
  \item total_mean_1, total_mean_2: Mean of read counts of group 1 and group 2.
  \item foldChange: total_mean_1/total_mean_2.
  \item norm_total_mean_1, norm_total_mean_2: Mean of normalized read counts of group 1 and group 2.
  \item norm_foldChange: norm_total_mean_1/norm_total_mean_2.
  \item chi2LR1: Chi-square statistic for hypothesis testing of H0.
  \item pvalue_LR2: P value of hypothesis testing of H20 (Used to determine the type of a DE gene).
  \item pvalue_LR3: P value of hypothesis testing of H30 (Used to determine the type of a DE gene).
  \item FDR_LR2: Adjusted P value of pvalue_LR2 using Benjamini & Hochberg's method (Used to determine the type of a DE gene).
  \item FDR_LR3: Adjusted P value of pvalue_LR3 using Benjamini & Hochberg's method (Used to determine the type of a DE gene).
  \item pvalue: P value of hypothesis testing of H0 (Used to determine whether a gene is a DE gene).
  \item pvalue.adj.FDR: Adjusted P value of H0's pvalue using Benjamini & Hochberg's method (Used to determine whether a gene is a DE gene).
  \item Remark: Record of abnormal program information.
  \item Type: Types of DE genes. DEs represents different expression status; DEa represents differential expression abundance; DEg represents general differential expression.
  \item State: State of DE genes, up represents up-regulated; down represents down-regulated.
}
}
\description{
This function is used to classify the differentially expressed genes of single-cell RNA-seq (scRNA-seq) data found by \code{DEsingle}. It takes the output data frame from \code{DEsingle} as input.
}
\examples{
# Load test data for DEsingle
data(TestData)

# Specifying the two groups to be compared
# The sample number in group 1 and group 2 is 50 and 100 respectively
group <- factor(c(rep(1,50), rep(2,100)))

# Detecting the differentially expressed genes
results <- DEsingle(counts = counts, group = group)

# Dividing the differentially expressed genes into 3 categories
results.classified <- DEtype(results = results, threshold = 0.05)

}
\seealso{
\code{\link{DEsingle}}, for the detection of differentially expressed genes from scRNA-seq data.

\code{\link{TestData}}, a test dataset for DEsingle.
}
\author{
Zhun Miao.
}
