% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEsingle.R
\name{DEsingle}
\alias{DEsingle}
\title{DEsingle: Detecting differentially expressed genes from scRNA-seq data}
\usage{
DEsingle(counts, group, parallel = FALSE, BPPARAM = bpparam())
}
\arguments{
\item{counts}{A non-negative integer matrix of scRNA-seq raw read counts or a \code{SingleCellExperiment} object which contains the read counts matrix. The rows of the matrix are genes and columns are samples/cells.}

\item{group}{A vector of factor which specifies the two groups to be compared, corresponding to the columns in the counts matrix.}

\item{parallel}{If FALSE (default), no parallel computation is used; if TRUE, parallel computation using \code{BiocParallel}, with argument \code{BPPARAM}.}

\item{BPPARAM}{An optional parameter object passed internally to \code{\link{bplapply}} when \code{parallel=TRUE}. If not specified, \code{\link{bpparam}()} (default) will be used.}
}
\value{
A data frame containing the differential expression (DE) analysis results, rows are genes and columns contain the following items:
\itemize{
  \item theta_1, theta_2, mu_1, mu_2, size_1, size_2, prob_1, prob_2: MLE of the zero-inflated negative binomial distribution's parameters of group 1 and group 2.
  \item total_mean_1, total_mean_2: Mean of read counts of group 1 and group 2.
  \item foldChange: total_mean_1/total_mean_2.
  \item norm_total_mean_1, norm_total_mean_2: Mean of normalized read counts of group 1 and group 2.
  \item norm_foldChange: norm_total_mean_1/norm_total_mean_2.
  \item chi2LR1: Chi-square statistic for hypothesis testing of H0.
  \item pvalue_LR2: P value of hypothesis testing of H20 (Used to determine the type of a DE gene).
  \item pvalue_LR3: P value of hypothesis testing of H30 (Used to determine the type of a DE gene).
  \item FDR_LR2: Adjusted P value of pvalue_LR2 using Benjamini & Hochberg's method (Used to determine the type of a DE gene).
  \item FDR_LR3: Adjusted P value of pvalue_LR3 using Benjamini & Hochberg's method (Used to determine the type of a DE gene).
  \item pvalue: P value of hypothesis testing of H0 (Used to determine whether a gene is a DE gene).
  \item pvalue.adj.FDR: Adjusted P value of H0's pvalue using Benjamini & Hochberg's method (Used to determine whether a gene is a DE gene).
  \item Remark: Record of abnormal program information.
}
}
\description{
This function is used to detect differentially expressed genes between two specified groups of cells in a raw read counts matrix of single-cell RNA-seq (scRNA-seq) data. It takes a non-negative integer matrix of scRNA-seq raw read counts or a \code{SingleCellExperiment} object as input. So users should map the reads (obtained from sequencing libraries of the samples) to the corresponding genome and count the reads mapped to each gene according to the gene annotation to get the raw read counts matrix in advance.
}
\examples{
# Load test data for DEsingle
data(TestData)

# Specifying the two groups to be compared
# The sample number in group 1 and group 2 is 50 and 100 respectively
group <- factor(c(rep(1,50), rep(2,100)))

# Detecting the differentially expressed genes
results <- DEsingle(counts = counts, group = group)

# Dividing the differentially expressed genes into 3 categories
results.classified <- DEtype(results = results, threshold = 0.05)

}
\seealso{
\code{\link{DEtype}}, for the classification of differentially expressed genes found by \code{\link{DEsingle}}.

\code{\link{TestData}}, a test dataset for DEsingle.
}
\author{
Zhun Miao.
}
