% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalizedLinearModel.r
\name{plotNeighbourhood}
\alias{plotNeighbourhood}
\title{Returns median expression from different conditions of genes from a neighbourhood of a gene of interest}
\usage{
plotNeighbourhood(
  pSmrExpt,
  pNearest_neighbours = 5,
  pDesign = ~condition,
  colorFactor = "condition",
  pGene_id
)
}
\arguments{
\item{pSmrExpt}{SummarizedExperiment object}

\item{pNearest_neighbours}{How many nearest neighbours within 1 Mb window to plot}

\item{pDesign}{design formula}

\item{colorFactor}{The coloring factor}

\item{pGene_id}{The gene of interest}
}
\value{
a list which contains both the data from the neighbourhood and a ggplot object
}
\description{
Returns median expression from different conditions of genes from a neighbourhood of a gene of interest
}
\examples{
count_matrix <- as.matrix(read.table(file = system.file("extdata",
                                                                  "tooth_RNASeq_counts.txt",
                                                                  package = "DELocal")))
colData <- data.frame(condition=gsub("\\\\..*",x=colnames(count_matrix),
                                     replacement = ""))
gene_location <- read.table(file = system.file("extdata", "gene_location.txt",
                                    package = "DELocal"))
smrExpt <- SummarizedExperiment::SummarizedExperiment(assays=list(counts=count_matrix),
                                            rowData = gene_location,
                                            colData = colData)
contrast= c("condition","ME13","ME14")
require(dplyr)
x_genes <- SummarizedExperiment::rowData(smrExpt) \%>\%
      as.data.frame() \%>\%
      filter(chromosome_name=="X") \%>\% rownames()
DELocal::plotNeighbourhood(pSmrExpt = smrExpt, pGene_id = "ENSMUSG00000059401")
}
