% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{as.DGEList}
\alias{as.DGEList}
\alias{as.DGEList.DESeqDataSet}
\title{Convert to DGEList}
\usage{
as.DGEList(x, ...)

\method{as.DGEList}{DESeqDataSet}(x, ...)
}
\arguments{
\item{x}{an \R object}

\item{...}{additional arguments to be passed to methods}
}
\value{
A \code{\linkS4class{DGEList}} object.
}
\description{
Coerces an object to \linkS4class{DGEList}.
}
\section{Methods (by class)}{
\itemize{
\item \code{as.DGEList(DESeqDataSet)}: Coerce \code{\linkS4class{DESeqDataSet}} objects to
\code{\link[edgeR]{DGEList-class}}.

}}
\examples{
require("DESeq2")

se = simulateRnaSeqData(output = "RangedSummarizedExperiment")
se

dds = DESeqDataSet(se, design = ~ condition)   
dds

as.DGEList(dds)
}
\seealso{
\code{\link{as.DESeqDataSet}}
}
\author{
Andrzej Oleś <\email{andrzej.oles@gmail.com}>, 2016-2023
}
