% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_simMat.R
\name{knn_simMat}
\alias{knn_simMat}
\title{Calculate stochastic transition matrix between clusters from a KNN connection
matrix}
\usage{
knn_simMat(KNN_matrix, clusters)
}
\arguments{
\item{KNN_matrix}{a sparse binary matrix with size (n_sample, n_sample).
x_ij=1 means sample j is a neighbour of sample i. As definition, we expect
sum(KNN_matrix) = n_sample * K, where K is the number neighbours.}

\item{clusters}{a (n_sample, ) vector of cluster id for each sample.}
}
\value{
a similarity matrix calculated based on the knn graph.
}
\description{
The transition probability from cluster i to j is the fraction of neighbours
of all samples in cluster i that belongs to cluster j. Note, this matrix is
asymmetric, so as the input KNN connection matrix.
}
\examples{
data(simulation)
knn_mat = knn_simMat(simulation$knnGraphs, simulation$labels)

}
