% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPhi.R
\name{getPhi}
\alias{getPhi}
\title{Calculate a global phi for all cell types}
\usage{
getPhi(count_mat, design_mat)
}
\arguments{
\item{count_mat}{A matrix of composition sizes (n_sample, n_cluster) for each
cluster in each sample}

\item{design_mat}{A matrix of testing candidate factors (n_sample, n_factor)
with same sample order as count_mat}
}
\value{
A number indicating a global phi for all cell types
}
\description{
Assuming all cell types share the same phi. This global phi can be calculate 
by pooling all cell types together to fit a beta binomial distribution.
}
\examples{
K <- 3
totals1 = c(100, 800, 1300, 600)
totals2 = c(250, 700, 1100)
diri_s1 = rep(1, K) * 20
diri_s2 = rep(1, K) * 20
simil_mat = DCATS::create_simMat(K, confuse_rate=0.2)
sim_dat <- DCATS::simulator_base(totals1, totals2, diri_s1, diri_s2, simil_mat)
sim_count = rbind(sim_dat$numb_cond1, sim_dat$numb_cond2)
sim_design = data.frame(condition = c("g1", "g1", "g1", "g1", "g2", "g2", "g2"))
phi = DCATS::getPhi(sim_count, sim_design)
}
