% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesImputation_PeptideLevel.R
\name{wrapper.impute.mle}
\alias{wrapper.impute.mle}
\title{Imputation of peptides having no values in a biological condition.}
\usage{
wrapper.impute.mle(obj)
}
\arguments{
\item{obj}{An object of class \code{MSnSet}.}
}
\value{
The \code{Biobase::exprs(obj)} matrix with imputed values instead 
of missing
values.
}
\description{
This method is a wrapper to the function \code{impute.mle()} of the 
package \code{imp4p} adapted to an object of class \code{MSnSet}.
It does not impute MEC missing values.
}
\examples{
utils::data(Exp1_R25_pept, package = "DAPARdata")
obj <- Exp1_R25_pept[seq_len(10), ]
level <- 'peptide'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeMatrix(metacell.mask, op = ">=", th = 1)
obj.imp.na <- wrapper.impute.mle(obj)

}
\author{
Samuel Wieczorek
}
