% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesImputation_ProteinLevel.R
\name{wrapper.impute.detQuant}
\alias{wrapper.impute.detQuant}
\title{Wrapper of the function `impute.detQuant()` for objects
of class \code{MSnSet}}
\usage{
wrapper.impute.detQuant(obj, qval = 0.025, factor = 1, na.type)
}
\arguments{
\item{obj}{An instance of class \code{MSnSet}}

\item{qval}{An expression set containing quantitative values of various
replicates}

\item{factor}{A scaling factor to multiply the imputation value with}

\item{na.type}{A string which indicates the type of missing values to impute.
Available values are: `NA` (for both POV and MEC), `POV`, `MEC`.}
}
\value{
An imputed instance of class \code{MSnSet}
}
\description{
This method is a wrapper of the function `impute.detQuant()` for objects
of class \code{MSnSet}
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept[seq_len(10)]
obj.imp.pov <- wrapper.impute.detQuant(obj, na.type = "Missing POV")
obj.imp.mec <- wrapper.impute.detQuant(obj, na.type = "Missing MEC")

}
\author{
Samuel Wieczorek
}
