% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_compare_Norm.R
\name{wrapper.compareNormalizationD_HC}
\alias{wrapper.compareNormalizationD_HC}
\title{Builds a plot from a dataframe}
\usage{
wrapper.compareNormalizationD_HC(
  objBefore,
  objAfter,
  condsForLegend = NULL,
  ...
)
}
\arguments{
\item{objBefore}{A dataframe that contains quantitative data before
normalization.}

\item{objAfter}{A dataframe that contains quantitative data after
normalization.}

\item{condsForLegend}{A vector of the conditions (one condition
per sample).}

\item{...}{arguments for palette}
}
\value{
A plot
}
\description{
Wrapper to the function that plot to compare the quantitative 
proteomics data before and after normalization.
}
\examples{

data(Exp1_R25_pept, package='DAPARdata')
obj <- Exp1_R25_pept
conds <- Biobase::pData(obj)[, "Condition"]
objAfter <- wrapper.normalizeD(
obj = obj, method = "QuantileCentering",
conds = conds, type = "within conditions"
)
wrapper.compareNormalizationD_HC(obj, objAfter, conds,
pal = ExtendPalette(2))

}
\author{
Samuel Wieczorek
}
