% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{visualizeClusters}
\alias{visualizeClusters}
\title{Visualize the clusters according to pvalue thresholds}
\usage{
visualizeClusters(
  dat,
  clust_model,
  adjusted_pValues,
  FDR_th = NULL,
  ttl = "",
  subttl = ""
)
}
\arguments{
\item{dat}{the standardize data returned by the function 
[checkClusterability()]}

\item{clust_model}{the clustering model obtained with dat.}

\item{adjusted_pValues}{vector of the adjusted pvalues obtained for each
protein with a 1-way ANOVA (for example obtained with the function
[wrapperClassic1wayAnova()]).}

\item{FDR_th}{the thresholds of FDR pvalues for the coloring of the profiles.
The default (NULL) creates 4 thresholds: 0.001, 0.005, 0.01, 0.05
For the sake of readability, a maximum of 4 values can be specified.}

\item{ttl}{title for the plot.}

\item{subttl}{subtitle for the plot.}
}
\value{
a ggplot object
}
\description{
Visualize the clusters according to pvalue thresholds
}
\examples{
library(dplyr)
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(1000)]
level <- 'protein'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeMatrix(metacell.mask, op = ">=", th = 1)
obj <- MetaCellFiltering(obj, indices, cmd = "delete")
expR25_ttest <- compute_t_tests(obj$new)
averaged_means <- averageIntensities(obj$new)
only_means <- dplyr::select_if(averaged_means, is.numeric)
only_features <- dplyr::select_if(averaged_means, is.character)
means <- purrr::map(purrr::array_branch(as.matrix(only_means), 1), mean)
centered <- only_means - unlist(means)
centered_means <- dplyr::bind_cols(
feature = dplyr::as_tibble(only_features),
dplyr::as_tibble(centered))
difference <- only_means[, 1] - only_means[, 2]
clusters <- as.data.frame(difference) \%>\%
dplyr::mutate(cluster = dplyr::if_else(difference > 0, 1, 2))
vizu <- visualizeClusters(
dat = centered_means,
clust_model = as.factor(clusters$cluster),
adjusted_pValues = expR25_ttest$P_Value$`25fmol_vs_10fmol_pval`,
FDR_th = c(0.001, 0.005, 0.01, 0.05),
ttl = "Clustering of protein profiles")
}
\author{
Helene Borges
}
