% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioAnalysis.R
\name{univ_AnnotDbPkg}
\alias{univ_AnnotDbPkg}
\title{Returns the totality of ENTREZ ID (gene id) of an OrgDb annotation
package. Careful : org.Pf.plasmo.db : no ENTREZID but ORF}
\usage{
univ_AnnotDbPkg(orgdb)
}
\arguments{
\item{orgdb}{a Bioconductor OrgDb annotation package}
}
\value{
A vector of ENTREZ ID
}
\description{
Function to compute the `universe` argument for the \code{enrich_GO}
function, in case this latter should be the entire organism.
Returns all the ID of the OrgDb annotation package for the corresponding
organism.
}
\examples{
if (!requireNamespace("org.Sc.sgd.db", quietly = TRUE)) {
stop("Please install org.Sc.sgd.db: 
            BiocManager::install('org.Sc.sgd.db')")
}
library(org.Sc.sgd.db)
univ_AnnotDbPkg("org.Sc.sgd.db")

}
\author{
Florence Combes
}
