% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacell_Plots.R
\name{metacellPerLinesHisto_HC}
\alias{metacellPerLinesHisto_HC}
\title{Bar plot of missing values per lines using highcharter}
\usage{
metacellPerLinesHisto_HC(
  obj,
  pattern = NULL,
  detailed = FALSE,
  indLegend = "auto",
  showValues = FALSE
)
}
\arguments{
\item{obj}{xxx.}

\item{pattern}{xxx}

\item{detailed}{'value' or 'percent'}

\item{indLegend}{The indice of the column name's in \code{Biobase::pData()} 
tab}

\item{showValues}{A logical that indicates whether numeric values should be
drawn above the bars.}
}
\value{
A bar plot
}
\description{
This method plots a bar plot which represents the distribution of the
number of missing values (NA) per lines (ie proteins).
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept

obj <- obj[1:10]

metacellPerLinesHisto_HC(obj, pattern = "Missing POV")

metacellPerLinesHisto_HC(obj)
metacellPerLinesHisto_HC(obj, pattern = "Quantified")
metacellPerLinesHisto_HC(obj, pattern = "Quant. by direct id")
metacellPerLinesHisto_HC(obj, pattern = "Quant. by recovery")
metacellPerLinesHisto_HC(obj, pattern = c("Quantified", "Quant. by direct id", "Quant. by recovery"))
}
\author{
Florence Combes, Samuel Wieczorek
}
