% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesisTest.R
\name{hc_logFC_DensityPlot}
\alias{hc_logFC_DensityPlot}
\title{Density plots of logFC values}
\usage{
hc_logFC_DensityPlot(df_logFC, threshold_LogFC = 0, pal = NULL)
}
\arguments{
\item{df_logFC}{A dataframe that contains the logFC values}

\item{threshold_LogFC}{The threshold on log(Fold Change) to
distinguish between differential and non-differential data}

\item{pal}{xxx}
}
\value{
A highcharts density plot
}
\description{
This function show the density plots of Fold Change (the same as calculated
by limma) for a list of the comparisons of conditions in a differential
analysis.
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(100)]
level <- 'protein'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeMatrix(metacell.mask, op = ">=", th = 1)
obj <- MetaCellFiltering(obj, indices, cmd = "delete")
qData <- Biobase::exprs(obj$new)
sTab <- Biobase::pData(obj$new)
res <- limmaCompleteTest(qData, sTab, comp.type = "OnevsAll")
pal <- ExtendPalette(2, "Dark2")
hc_logFC_DensityPlot(res$logFC, threshold_LogFC = 1, pal = pal)

}
\author{
Samuel Wieczorek
}
