% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_analysis.R
\name{globalAdjPval}
\alias{globalAdjPval}
\title{Computes the adjusted p-values on all the stacked contrasts using CP4P}
\usage{
globalAdjPval(x, pval.threshold = 1.05, method = 1, display = T)
}
\arguments{
\item{x}{a proteins x contrasts dataframe of (raw) p-values}

\item{pval.threshold}{all the p-values above the threshold are not considered. 
Default is 1.05 (which is equivalent to have no threshold).
Applying a threshold nearby 1 can be instrumental to improve the uniformity under the null, notably
in case of upstream mutliple contrat correction (for experienced users only)}

\item{method}{method a method to estimate pi_0, see CP4P}

\item{display}{if T, a calibration plot is diplayed using CP4P}
}
\value{
a proteins x contrasts table of adjusted p-values
}
\description{
Computes the adjusted p-values on all the stacked contrasts using CP4P
}
\examples{
data(Exp1_R25_prot, package='DAPARdata')
exdata <- Exp1_R25_prot[1:5,]
globalAdjPval(testAnovaModels(applyAnovasOnProteins(exdata), "TukeyHSD")$P_Value)

}
\author{
Thomas Burger
}
