% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getIndicesConditions}
\alias{getIndicesConditions}
\title{Gets the conditions indices.}
\usage{
getIndicesConditions(conds, cond1, cond2)
}
\arguments{
\item{conds}{A vector of strings containing the column "Condition" of
the \code{Biobase::pData()}.}

\item{cond1}{A vector of Conditions (a slot in the \code{Biobase::pData()} 
table) for the condition 1.}

\item{cond2}{A vector of Conditions (a slot in the \code{Biobase::pData()} 
table) for the condition 2.}
}
\value{
A list with two slots \code{iCond1} and \code{iCond2} containing
respectively the indices of samples in the \code{Biobase::pData()} table 
of the dataset.
}
\description{
Returns a list for the two conditions where each slot is a vector of
indices for the samples.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
conds <- Biobase::pData(Exp1_R25_pept)[, "Condition"]
getIndicesConditions(conds, "25fmol", "10fmol")

}
\author{
Florence Combes, Samuel Wieczorek
}
