% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcanoPlot.R
\name{diffAnaVolcanoplot}
\alias{diffAnaVolcanoplot}
\title{Volcanoplot of the differential analysis}
\usage{
diffAnaVolcanoplot(
  logFC = NULL,
  pVal = NULL,
  threshold_pVal = 1e-60,
  threshold_logFC = 0,
  conditions = NULL,
  colors = NULL
)
}
\arguments{
\item{logFC}{A vector of the log(fold change) values of the differential
analysis.}

\item{pVal}{A vector of the p-value values returned by the differential
analysis.}

\item{threshold_pVal}{A floating number which represents the p-value that
separates differential and non-differential data.}

\item{threshold_logFC}{A floating number which represents the log of the
Fold Change that separates differential and non-differential data.}

\item{conditions}{A list of the names of condition 1 and 2 used for the
differential analysis.}

\item{colors}{xxx}
}
\value{
A volcanoplot
}
\description{
Plots a volcanoplot after the differential analysis.
Typically, the log of Fold Change is represented on the X-axis and the
log10 of the p-value is drawn on the Y-axis. When the \code{threshold_pVal}
and the \code{threshold_logFC} are set, two lines are drawn respectively on
the y-axis and the X-axis to visually distinguish between differential and
non differential data.
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(100)]
level <- 'protein'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeMatrix(metacell.mask, op = ">=", th = 1)
obj <- MetaCellFiltering(obj, indices, cmd = "delete")
qData <- Biobase::exprs(obj$new)
sTab <- Biobase::pData(obj$new)
limma <- limmaCompleteTest(qData, sTab)
diffAnaVolcanoplot(limma$logFC[, 1], limma$P_Value[, 1])

}
\author{
Florence Combes, Samuel Wieczorek
}
