% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiffAnalysis.R
\name{diffAnaGetSignificant}
\alias{diffAnaGetSignificant}
\title{Returns a MSnSet object with only proteins significant after
differential analysis.}
\usage{
diffAnaGetSignificant(obj)
}
\arguments{
\item{obj}{An object of class \code{MSnSet}.}
}
\value{
A MSnSet
}
\description{
Returns a MSnSet object with only proteins significant after differential 
analysis.
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(100)]
level <- 'protein'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeMatrix(metacell.mask, op = ">=", th = 1)
obj <- MetaCellFiltering(obj, indices, cmd = "delete")
qData <- Biobase::exprs(obj$new)
sTab <- Biobase::pData(obj$new)
allComp <- limmaCompleteTest(qData, sTab)
data <- list(logFC = allComp$logFC[1], P_Value = allComp$P_Value[1])
obj$new <- diffAnaSave(obj$new, allComp, data)
signif <- diffAnaGetSignificant(obj$new)

}
\author{
Alexia Dorffer
}
