% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inOutFiles.R
\name{createMSnset2}
\alias{createMSnset2}
\title{Creates an object of class \code{MSnSet} from text file}
\usage{
createMSnset2(
  file,
  metadata = NULL,
  qdataNames,
  colnameForID = NULL,
  metacellNames = NULL,
  logData = FALSE,
  replaceZeros = FALSE,
  pep_prot_data = NULL,
  proteinId = NULL,
  software = NULL
)
}
\arguments{
\item{file}{The name of a tab-separated file that contains the data.}

\item{metadata}{A dataframe describing the samples (in lines).}

\item{qdataNames}{A vector of string where each element is the name
of a column in designTable that have to be integrated in
the \code{Biobase::fData()} table of the \code{MSnSet} object.}

\item{colnameForID}{The name of the column containing the ID of entities
(peptides or proteins)}

\item{metacellNames}{xxxxxxxxxxx}

\item{logData}{A boolean value to indicate if the data have to be
log-transformed (Default is FALSE)}

\item{replaceZeros}{A boolean value to indicate if the 0 and NaN values of
intensity have to be replaced by NA (Default is FALSE)}

\item{pep_prot_data}{A string that indicates whether the dataset is about}

\item{proteinId}{xxxx}

\item{software}{xxx}
}
\value{
An instance of class \code{MSnSet}.
}
\description{
Builds an object of class \code{MSnSet} from a single tabulated-like file 
for quantitative and meta-data and a dataframe for the samples description. 
It differs from the original \code{MSnSet} builder which requires three 
separated files tabulated-like quantitative proteomic data into a 
\code{MSnSet} object, including metadata.
}
\examples{
require(Matrix)
exprsFile <- system.file("extdata", "Exp1_R25_pept.txt", 
package = "DAPARdata")
metadataFile <- system.file("extdata", "samples_Exp1_R25.txt",
    package = "DAPARdata"
)
metadata <- read.table(metadataFile, header = TRUE, sep = "\t", 
as.is = TRUE)
indExpData <- seq.int(from=56, to=61)
colnameForID <- "id"
obj <- createMSnset(exprsFile, metadata, indExpData, colnameForID,
    indexForMetacell = seq.int(from=43, to=48), pep_prot_data = "peptide", 
    software = "maxquant"
)


exprsFile <- system.file("extdata", "Exp1_R25_pept.txt", 
package = "DAPARdata")
metadataFile <- system.file("extdata", "samples_Exp1_R25.txt", 
package = "DAPARdata")
metadata <- read.table(metadataFile, header = TRUE, sep = "\t", 
as.is = TRUE)
indExpData <- seq.int(from = 56, to = 61)
colnameForID <- "AutoID"
obj <- createMSnset(exprsFile, metadata, indExpData, colnameForID,
indexForMetacell = seq.int(from = 43, to = 48), 
pep_prot_data = "peptide", software = "maxquant"
)

}
\author{
Florence Combes, Samuel Wieczorek
}
