% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioAnalysis.R
\name{barplotEnrichGO_HC}
\alias{barplotEnrichGO_HC}
\title{A barplot that shows the result of a GO enrichment, using the
package \code{highcharter}}
\usage{
barplotEnrichGO_HC(ego, maxRes = 5, title = NULL)
}
\arguments{
\item{ego}{The result of the GO enrichment, provides either by the function
\code{enrichGO} in the package \code{DAPAR} or the function \code{enrichGO}
of the package `clusterProfiler`}

\item{maxRes}{The maximum number of categories to display in the plot}

\item{title}{The title of the plot}
}
\value{
A barplot
}
\description{
A barplot of GO enrichment analysis
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(10)]
if (!requireNamespace("org.Sc.sgd.db", quietly = TRUE)) {
stop("Please install org.Sc.sgd.db: 
            BiocManager::install('org.Sc.sgd.db')")
}
library(org.Sc.sgd.db)
univ <- univ_AnnotDbPkg("org.Sc.sgd.db")
ego <- enrich_GO(
    data = Biobase::fData(obj)$Protein.IDs, idFrom = "UNIPROT",
    orgdb = "org.Sc.sgd.db", ont = "MF", pval = 0.05, universe = univ
)
barplotEnrichGO_HC(ego)

}
\author{
Samuel Wieczorek
}
