% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacell.R
\name{Set_POV_MEC_tags}
\alias{Set_POV_MEC_tags}
\title{Sets the MEC tag in the metacell}
\usage{
Set_POV_MEC_tags(conds, df, level)
}
\arguments{
\item{conds}{xxx}

\item{df}{An object of class \code{MSnSet}}

\item{level}{Type of entity/pipeline}
}
\value{
An instance of class \code{MSnSet}.
}
\description{
This function is based on the metacell dataframe to look for either missing
values (used to update an initial dataset) or imputed values (used when
post processing protein metacell after aggregation)
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept[seq_len(10)]
cols.for.ident <- c("metacell_Intensity_C_R1", "metacell_Intensity_C_R2",
"metacell_Intensity_C_R3", "metacell_Intensity_D_R1",
"metacell_Intensity_D_R2", "metacell_Intensity_D_R3")
conds <- Biobase::pData(obj)$Condition
df <- Biobase::fData(obj)[, cols.for.ident]
df <- Set_POV_MEC_tags(conds, df, level = "peptide")

}
\author{
Samuel Wieczorek
}
