% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{SetCC}
\alias{SetCC}
\title{Returns the connected components}
\usage{
SetCC(obj, cc)
}
\arguments{
\item{obj}{An object (peptides) of class \code{MSnSet}.}

\item{cc}{The connected components list}
}
\value{
xxx
}
\description{
Returns the connected components
}
\examples{
data(Exp1_R25_pept, package='DAPARdata')
Xshared <- BuildAdjacencyMatrix(Exp1_R25_pept[seq_len(100)], 
"Protein_group_IDs", FALSE)
Xunique <- BuildAdjacencyMatrix(Exp1_R25_pept[seq_len(100)], 
"Protein_group_IDs", TRUE)
ll.X <- list(matWithSharedPeptides = Xshared, 
matWithUniquePeptides = Xunique)
Exp1_R25_pept <- SetMatAdj(Exp1_R25_pept, ll.X)
ll1 <- get.pep.prot.cc(GetMatAdj(Exp1_R25_pept)$matWithSharedPeptides)
ll2 <- get.pep.prot.cc(
GetMatAdj(Exp1_R25_pept)$matWithUniquePeptides)
cc <- list(allPep = ll1, onlyUniquePep = ll2)
Exp1_R25_pept <- SetCC(Exp1_R25_pept, cc)

}
\author{
Samuel Wieczorek
}
