% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agregation.R
\name{GetNbPeptidesUsed}
\alias{GetNbPeptidesUsed}
\title{Computes the number of peptides used for aggregating each protein}
\usage{
GetNbPeptidesUsed(X, pepData)
}
\arguments{
\item{X}{An adjacency matrix}

\item{pepData}{A data.frame of quantitative data}
}
\value{
A data.frame
}
\description{
Method to compute the number of quantified peptides used for aggregating
each protein
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
protID <- "Protein_group_IDs"
obj.pep <- Exp1_R25_pept[seq_len(10)]
X <- BuildAdjacencyMatrix(obj.pep, protID, FALSE)
pepData <- Biobase::exprs(obj.pep)
GetNbPeptidesUsed(X, pepData)

}
\author{
Samuel Wieczorek
}
