% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacell.R
\name{GetMetacellTags}
\alias{GetMetacellTags}
\title{List of metacell tags}
\usage{
GetMetacellTags(level = NULL, obj = NULL, onlyPresent = FALSE, all = FALSE)
}
\arguments{
\item{level}{xxx}

\item{obj}{An object of class \code{MSnSet}}

\item{onlyPresent}{A boolean that indicates if one wants a list with only the tags
present in the dataset.}

\item{all}{A boolean that indicates if one wants the whole list}
}
\value{
A vector of tags..
}
\description{
This function gives the list of metacell tags available in DAPAR.

- onlyPresent: In this case, the function gives the tags found in a dataset.
In addition, and w.r.t to the hierarchy of tags, if all leaves of a node are
present, then the tag corresponding to this node is added.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept
GetMetacellTags(level="peptide")
GetMetacellTags(level="peptide", obj, onlyPresent=TRUE)

}
\author{
Samuel Wieczorek
}
