% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesFilter.R
\name{GetIndices_WholeMatrix}
\alias{GetIndices_WholeMatrix}
\title{Search lines which respects request on one or more conditions.}
\usage{
GetIndices_WholeMatrix(metacell.mask, op = "==", percent = FALSE, th = 0)
}
\arguments{
\item{metacell.mask}{xxx}

\item{op}{String for operator to use. List of operators is available with 
SymFilteringOperators().}

\item{percent}{A boolean to indicate whether the threshold represent an 
absolute value (percent = FALSE) or
a percentage (percent=TRUE).}

\item{th}{A floating number which is in the interval [0, 1]}
}
\value{
xxx
}
\description{
This function looks for the lines that respect the request in either all 
conditions or at least one condition.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept[seq_len(10)]
level <- 'peptide'
pattern <- "Missing"
metacell.mask <- match.metacell(metadata = GetMetacell(obj), 
pattern = pattern, level = level)
percent <- FALSE
th <- 3
op <- ">="
ind <- GetIndices_WholeMatrix(metacell.mask, op, percent, th)

}
