% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agregation.R
\name{GetDetailedNbPeptides}
\alias{GetDetailedNbPeptides}
\title{Computes the detailed number of peptides for each protein}
\usage{
GetDetailedNbPeptides(X)
}
\arguments{
\item{X}{An adjacency matrix}
}
\value{
A data.frame
}
\description{
Method to compute the detailed number of quantified peptides for each
protein
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj.pep <- Exp1_R25_pept[seq_len(10)]
protID <- "Protein_group_IDs"
X <- BuildAdjacencyMatrix(obj.pep, protID, FALSE)
n <- GetDetailedNbPeptides(X)

}
\author{
Samuel Wieczorek
}
