% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agregation.R
\name{BuildAdjacencyMatrix}
\alias{BuildAdjacencyMatrix}
\title{Function matrix of appartenance group}
\usage{
BuildAdjacencyMatrix(obj.pep, protID, unique = TRUE)
}
\arguments{
\item{obj.pep}{An object (peptides) of class \code{MSnSet}.}

\item{protID}{The name of proteins ID column}

\item{unique}{A boolean to indicate whether only the unique peptides must
be considered (TRUE) or if the shared peptides have to be integrated (FALSE).}
}
\value{
A binary matrix
}
\description{
Method to create a binary matrix with proteins in columns and peptides
in lines on a \code{MSnSet} object (peptides)
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
protId <- "Protein_group_IDs"
BuildAdjacencyMatrix(Exp1_R25_pept[seq_len(10)], protId, TRUE)

}
\author{
Florence Combes, Samuel Wieczorek, Alexia Dorffer
}
