% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tuples.R
\name{read_tuples}
\alias{read_tuples}
\title{Read in list of methtuple files}
\usage{
read_tuples(files, sampleNames, minCoverage = 2, maxGap = 20, verbose = TRUE)
}
\arguments{
\item{files}{List of methtuple files.}

\item{sampleNames}{Names of files in the list.}

\item{minCoverage}{The minimum coverage per tuple. Tuples with a coverage <
minCoverage are filtered out. Default = 2.}

\item{maxGap}{The maximum allowed distance between two positions in a tuple.
Only distances that are <= maxGap are kept. Default = 150 base pairs.}

\item{verbose}{If the function should be verbose.}
}
\value{
A list of data frames, where each data frame corresponds to one file.
}
\description{
This function reads in a list of files obtained from the methtuple tool. It
filters out tuples based on the set minimum coverage (min_cov) and the
maximum allowed distance (maxGap) between two genomic positions in a tuple.
}
\examples{
DATA_PATH_DIR <- system.file('extdata', '.', package = 'DAMEfinder')
get_data_path <- function(file_name) file.path(DATA_PATH_DIR, file_name)

tuple_files <- list.files(DATA_PATH_DIR, '.tsv.gz')
tuple_files <- get_data_path(tuple_files)
ASM <- read_tuples(tuple_files, c('CRC1', 'NORM1'))

}
