% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methyl_circle_plot.R
\name{methyl_circle_plot}
\alias{methyl_circle_plot}
\title{Draw methylation circle plot}
\usage{
methyl_circle_plot(
  snp,
  vcfFile,
  bamFile,
  refFile,
  build = "hg19",
  dame = NULL,
  letterSize = 2.5,
  pointSize = 3,
  sampleName = "sample1",
  cpgsite = NULL,
  sampleReads = FALSE,
  numReads = 20
)
}
\arguments{
\item{snp}{GRanges object containing SNP location.}

\item{vcfFile}{vcf file.}

\item{bamFile}{bismark bam file path.}

\item{refFile}{fasta reference file path. Or \code{DNAStringSet} with DNA
sequence.}

\item{build}{genome build used. default = "hg19"}

\item{dame}{(optional) GRanges object containing a region to plot.}

\item{letterSize}{Size of alleles drawn in plot. Default = 2.5.}

\item{pointSize}{Size of methylation circles. Default = 3.}

\item{sampleName}{FIX?: this is to save the vcf file to not generate it every
time you run the function.}

\item{cpgsite}{(optional) GRanges object containing a single CpG site
location of interest.}

\item{sampleReads}{Whether a subset of reads should be plotted.
Default = FALSE.}

\item{numReads}{Number of reads to plot per allele, if sampleReads is TRUE.
Default = 20}
}
\value{
Plot
}
\description{
Draws CpG site methylation status as points, in reads containing a specific
SNP. Generates one plot per bam file.
}
\examples{
DATA_PATH_DIR <- system.file('extdata', '.', package = 'DAMEfinder')

get_data_path <- function(file_name) file.path(DATA_PATH_DIR, file_name)
bam_files <- get_data_path('NORM1_chr19_trim.bam')
vcf_files <- get_data_path('NORM1.chr19.trim.vcf')
sample_names <- 'NORM1'
#reference_file
suppressPackageStartupMessages({library(BSgenome.Hsapiens.UCSC.hg19)})
genome <- BSgenome.Hsapiens.UCSC.hg19
seqnames(genome) <- gsub("chr","",seqnames(genome))
dna <- DNAStringSet(genome[[19]], use.names = TRUE)
names(dna) <- 19

snp <- GenomicRanges::GRanges(19, IRanges::IRanges(292082, width = 1))
methyl_circle_plot(snp = snp,
 vcfFile = vcf_files,
 bamFile = bam_files,
 refFile = dna,
 sampleName = sample_names)

}
