% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_bams.R
\name{extract_bams}
\alias{extract_bams}
\title{Detect allele-specific methylation from a bam file}
\usage{
extract_bams(
  bamFiles,
  vcfFiles,
  sampleNames,
  referenceFile,
  coverage = 4,
  cores = 1,
  verbose = TRUE
)
}
\arguments{
\item{bamFiles}{List of bam files.}

\item{vcfFiles}{List of vcf files.}

\item{sampleNames}{Names of files in the list.}

\item{referenceFile}{fasta file used to generate the bam files. Or 
\code{DNAStringSet} with DNA sequence.}

\item{coverage}{Minimum number of reads covering a CpG site on each allele.
Default = 2.}

\item{cores}{Number of cores to use. See package {parallel} for description
of core. Default = 1.}

\item{verbose}{Default = TRUE}
}
\value{
A list of GRanges for each sample. Each list is saved in a separate
  .rds file.
}
\description{
The function takes a bam (from bismark) and vcf file for each sample. For
each SNP contained in the vcfile it calculates the proportion of methylated
reads for each CpG site at each allele. At the end it returns (saves to
working directory) a GRanges list, where each GRanges contains all the CpG
sites overlapping the reads containing a specific SNP.
}
\examples{
DATA_PATH_DIR <- system.file('extdata', '.', package = 'DAMEfinder')
get_data_path <- function(file_name) file.path(DATA_PATH_DIR, file_name)
bamFiles <- get_data_path('NORM1_chr19_trim.bam')
vcfFiles <- get_data_path('NORM1.chr19.trim.vcf')
sampleNames <- 'NORM1'

#referenceFile 
suppressPackageStartupMessages({library(BSgenome.Hsapiens.UCSC.hg19)})
genome <- BSgenome.Hsapiens.UCSC.hg19
seqnames(genome) <- gsub("chr","",seqnames(genome))
dna <- DNAStringSet(genome[[19]], use.names = TRUE)
names(dna) <- 19

GRanges_list <- extract_bams(bamFiles, vcfFiles, sampleNames, dna)

}
