% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphGML_methods.R
\name{getNodes,graphGML-method}
\alias{getNodes,graphGML-method}
\title{get nodes from {graphGML} object}
\usage{
\S4method{getNodes}{graphGML}(x, y, order = c("default", "bfs", "dfs", "tsort"), only.names = TRUE)
}
\arguments{
\item{x}{\code{graphGML}}

\item{y}{\code{character} node index. When \code{missing}, return all the nodes}

\item{order}{\code{character} specifying the order of nodes. options are "default", "bfs", "dfs", "tsort"}

\item{only.names}{\code{logical} specifiying whether user wants to get the entire \code{nodeData} or just the name of the population node}
}
\value{
It returns the node names and population names by default. Or return the entire nodeData associated with each node.
}
\description{
get nodes from {graphGML} object
}
\examples{
\dontrun{
g <- read.gatingML.cytobank(xmlfile)
getNodes(g)
getNodes(g, only.names = FALSE)
}
}
