% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoDx.pred.R
\name{CytoDx.pred}
\alias{CytoDx.pred}
\title{Make prediction using the CytoDx model}
\usage{
CytoDx.pred(fit, xNew, xSampleNew)
}
\arguments{
\item{fit}{The two stage statistical model. Must be the object returned by CytoDx.fit.}

\item{xNew}{The marker profile of cells pooled from all new samples. Each row is a cell, each column is
a marker.}

\item{xSampleNew}{A vector specifying which sample each cell belongs to. Length
must equal to nrow(xNew).}
}
\value{
Returns a list. xNew.Pred1 contains the predicted y for the new data at the cell level.
  xNew.Pred2 contains the predicted y for the new data at the sample level.
}
\description{
A function that makes prediction using the CytoDx model.
}
\examples{
# Find the table containing fcs file names in CytoDx package
path <- system.file("extdata",package="CytoDx")
# read the table
fcs_info <- read.csv(file.path(path,"fcs_info.csv"))
# Specify the path to the cytometry files
fn <- file.path(path,fcs_info$fcsName)
train_data <- fcs2DF(fcsFiles=fn,
                    y=fcs_info$Label,
                    assay="FCM",
                    b=1/150,
                    excludeTransformParameters=
                      c("FSC-A","FSC-W","FSC-H","Time"))
# build the model
fit <- CytoDx.fit(x=as.matrix(train_data[,1:7]),
                y=train_data$y,
                xSample = train_data$xSample,
                reg=FALSE,
                family="binomial")
# check accuracy for training data
pred <- CytoDx.pred(fit,
                   xNew=as.matrix(train_data[,1:7]),
                   xSampleNew=train_data$xSample)

boxplot(pred$xNew.Pred.sample$y.Pred.s0~
          fcs_info$Label)

}
