% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoDx.fit.R
\name{CytoDx.fit}
\alias{CytoDx.fit}
\title{Build the CytoDx model}
\usage{
CytoDx.fit(x, y, xSample, family = c("gaussian", "binomial", "poisson",
  "multinomial", "cox", "mgaussian"), type1 = "response",
  type2 = "response", parallelCore = 1, reg = FALSE, ...)
}
\arguments{
\item{x}{The marker profile of cells pooled from all samples. Each row is a cell, each column is
a marker.}

\item{y}{The clinical outcomes associated with samples to which cells belong. Length must be equal to nrow(x). For
family="binomial" should be either a factor with two levels, or a
two-column matrix of counts or proportions (the second column is treated as
the target class; for a factor, the last level in alphabetical order is the
target class). For family="multinomial", can be a nc>=2 level factor, or a
matrix with nc columns of counts or proportions. For either "binomial" or
"multinomial", if y is presented as a vector, it will be coerced into a
factor. For family="cox", y should be a two-column matrix with columns
named 'time' and 'status'. The latter is a binary variable, with '1'
indicating death, and '0' indicating right censored. The function Surv() in
package survival produces such a matrix. For family="mgaussian", y is a
matrix of quantitative responses.}

\item{xSample}{A vector specifying which sample each cell belongs to. Length
must equal to nrow(x).}

\item{family}{Response type. Must be one of the following:
"gaussian","binomial","poisson","multinomial","cox","mgaussian"}

\item{type1}{Type of first level prediction. Type of prediction required.
Type "link" gives the linear predictors for "binomial", "multinomial",
"poisson" or "cox" models; for "gaussian" models it gives the fitted
values. Type "response" gives the fitted probabilities for "binomial" or
"multinomial", fitted mean for "poisson" and the fitted relative-risk for
"cox"; for "gaussian" type "response" is equivalent to type "link".}

\item{type2}{Type of second level prediction.}

\item{parallelCore}{The number of core to be used. Only used when reg is
TRUE.}

\item{reg}{If elestic net regularization will be used.}

\item{...}{Other parameters to be passed into the glmnet or the cv.glmnet
function in the glmnet package.}
}
\value{
Returns a list. train.Data.cell contains the trainig data and the
  predicted y for the training data at the cell level. model.cell contains the
  cell stage statistical model. Data.sample contains the trainig data and the
  predicted y for the training data at the sample level. model.sample contains the
  sample stage statistical model. family specifies the regression type.
  method specifies the type of learning method. type.cell is the type of cell
  level prediction. type.sample is the type of sample level prediction.
}
\description{
A function that builds the CytoDx model.
}
\examples{
# Find the table containing fcs file names in CytoDx package
path <- system.file("extdata",package="CytoDx")
# read the table
fcs_info <- read.csv(file.path(path,"fcs_info.csv"))
# Specify the path to the cytometry files
fn <- file.path(path,fcs_info$fcsName)
# Read cytometry files using fcs2DF function
train_data <- fcs2DF(fcsFiles=fn,
                    y=fcs_info$Label,
                    assay="FCM",
                    b=1/150,
                    excludeTransformParameters=
                      c("FSC-A","FSC-W","FSC-H","Time"))
# build the model
fit <- CytoDx.fit(x=as.matrix(train_data[,1:7]),
                y=train_data$y,
                xSample = train_data$xSample,
                reg=FALSE,
                family="binomial")
# check accuracy for training data
pred <- CytoDx.pred(fit,
                   xNew=as.matrix(train_data[,1:7]),
                   xSampleNew=train_data$xSample)

boxplot(pred$xNew.Pred.sample$y.Pred.s0~
          fcs_info$Label)

}
