library(zellkonverter)
library(SingleCellExperiment) # load early to avoid masking dplyr::count()
library(tidySingleCellExperiment)
library(dplyr)
library(cellxgenedp)
library(tidyverse)
#library(tidySingleCellExperiment)
library(stringr)
library(scMerge)
library(glue)
library(DelayedArray)
library(HDF5Array)




# # CREATE MAKEFILE
# tab = "\t"
# root_directory = "/vast/projects/RCP/human_cell_atlas"
# splitted_data_directory = glue("{root_directory}/splitted_data_0.2")
# light_data_directory = glue("{root_directory}/splitted_light_data_0.2")
# gene_names = glue("{root_directory}/gene_names.rds")
# files_metadata = glue("{root_directory}/files_metadata.rds")
# metadata_path = glue('{root_directory}/metadata_0.2.rds')
#
#
# 	readRDS(metadata_path) |>
# 	distinct(.sample, file_id) |>
# 	mutate(
# 		input_file_path = glue("{splitted_data_directory}/{.sample}") |> as.character(),
# 		output_file_path = glue("{light_data_directory}/{.sample}" |> as.character())
# 	) |>
#
# 	mutate(Mb = map_dbl(input_file_path, ~
# 												( (file.info(glue("{.x}/se.rds"))$size /1e6) |> as.integer() ) +
# 												( (file.info(glue("{.x}/assays.h5"))$size /1e6) |> as.integer() )
# 	)) |>
# 	mutate(memory = pmax(Mb * 20, 10000)) |>
#
# 	mutate(memory = if_else(
# 		.sample %in% c(
# 			"798a197e8c631c7345c7b5db86aa0099", "b578d67f13d5c1798bf6d7e49eb19786", "1da01dae037d413ca5161e64229c4b60", "0e34419d1e7a77ffb4332168e8a94202", "5cdfbafc74661baed508ca5a342785d4", "d22a8762ffc8f5b4c9ce89b76728e2d2", "adb5a59e1b3ec8a25b029d84ed1c7ad8", "95cf4fde9c8d581a8ec9c9923820530a", "555571de62c82cc60a5b41d01519e33e", "5b9c748e709e85b966a39c92f3489833",
# 			'd1968809ebb254074e753eacf32d7139', '93e5af6aa9d9fe8048a904c2909c6f8f', 'f60dc5e5664eb14f8322f18595013d1b', '1db065d59d0ed4317154dec39af5a139', 'ba23763fe88bb933ac8e97e3f57b723d', '8862ac60f1030a33b6e0b8c0bff547a0', 'a920c91b2b3bb162300023b5b130539d', '0bff3b0b3f160ebb601b18a29a76284c', '9beaee1817c24fd56635f9a9362b33c1', '716ce343e9a9c1bb7421df697705f0f5', 'fa5d0ae5397801e59402ab4e53e6fe48', 'c1b47b31dd475eaa93925ca49ef4e7c4', '654c2c8952f5915b4bb3991068a5bb3b', 'f0ee20f2f57dd77b99b7fae8118945ee', '92f800f432ca7b4a28166420e58233e3', '59db4dbe851482cf8ae4cc475ef1fcf9', 'ca272a23b638d90dc07f33e19fd5c2f5', '6baddc488c6291838ec21da4d4e37b49', 'a6730d3d9e42aaf7ed291bf6dc8b7b57', '2b36b2e6fb11df1fd7a584b0504e10d5', '4d582a77abd6ceddf56b4c34e981876a', 'a2eb75e9881da3d73ffc2ccd6adafb41', '5326f6dc9325466da9e6ca34cbe71261', '34c1c2e3f21e652030a00b0da09563fc', 'c1c48773892e1a860e6a1b18f3aa2b66', 'bdea47b043c259bbf067a1d9936b0fed', 'da6bd1843c666b0640773d2b540520b2', 'e5c653c53fea25e8996696b8390c5c3a', '605c3390e2ea9936f279e7d4c865d566', 'd526ac3df77d905b503ec68e38f4512d', '7012fbf79a9be211e05026ecf5eef851', '1a9a4d9ffc185de9737274e25698e3a0', '6ba888e98af2f5c0dbe0daa14a8438a8', '9ba6f81f2ff1cd1fe3004b673237142f', '3ea62ffb26756b2395d526c09c85775a', '06dceeb36793437a7c78699c4c8a192a', '1633773e5f041259cb2abc1aef3c3af0', 'd99dbc32dfaffc87a80600aa56afaf6a', '284bdaf4229af4debf9f94895953b1f6', '0f5c442ff7f7fa84fd15848d12b8a7f4', 'e06ebc6995b7726de0dbbb7c88238068', '47bfda35d332fd7b7b7fe045a981d751', '77271c10dd30e0cf69d5aabeef242aa4', '1bc112f1deda2da409b6b4852e7ccc05', 'aa750523adf4074a967f3645592164ce', 'f1be9b9e34c2213936fce61bdd9ee9c8', '01e1556e21269a932b0e80d66ba67742', 'd18fd305f091b8d95b9d17211af24be0', 'a38371d96265c22a334913553d3e8770', '5f2725c9c25b9bd821ef74841c148600', 'f595506b03465ac3f4f4c2f0377329c8', '9c80d269291e591f0180fe9917a38674', 'a4eaa811cd036b1d7f6c033ec491f4b1', '3c1f0d2eb04a6af1b13afee9b78c9f94', '29bdc14cab6c60cf5723c4ec37f008d7', '4294d63e035eec529767d3df03847e5d', '90ebaa5a98e38d64d6bcda56c2e9af2e', '4861c228717405fa235529687e4d1f41', '5fa33dc7337fb6f22bddd87575a7449e', '029944bde5bbbd3af785e94d480e00c7', 'a0884b08a0fd4c394d32f569ad0099c2', '2cab5d01302058073cbcb6f1d58c175d', '250ec53179258a6cbbc7e538fa247c93', '4756a7bc21e65f74de0c44cb558451eb', '25bf6411691a9bd2df90cbba86de7b53', '1185d89f9ba6ec5d17e9e35fbf30b284', '5b44fe0676adc188299afe2085d6d6f6', '005f92415d0a4456f6e69c59ab8b744a', 'cc01cf5f758c24a549b53eea508a12ba', '6254d9adc7ccfa2194d9dee1f953bdc8', '548cc1ecec6f51eed8888e6e75386528', 'd269cc3d24192253915c76548a76f98f', 'eb3ab31045df7a1fa33cce82631f8f65', 'b1318ce9d55917c965ddb646aa473b48', '043c0a5ded155f0e72648c62f8b4b835', 'f3ee387727c7bdc3512f5a4dda65f42b', '20968a5c87b65b02d8bcc8cc1af2ae73', '34e775390b27327392dbd3386ef29a8d', 'dff95c09cc4f91b74ed8d490216550af', '1f72d7cc7a792a5d01190f13a0aa2f34', 'fbbcb7a4e03895bfb7ebd66d4367ed99', 'b710bc9bd6a9392065ba4f0f8f1cba75', 'c340a1df81e61ab097470c1175d09f1a', 'e679dbc708686bfbe1e09a4eee798b6d', '2f8705402960cca3b781da0c13e3c190', 'b3bc36ceffb0e4f82cbf168c74030714', 'ff88ad05e24bccfb84e871edb8ba79cb', '74089f67ff38dbf310778a062e1dd7c6', 'e79d50ec9429f71a531cba799f1a11f1', 'e99979b90efe88f83c642758bed1876d', '6af766659f8591373c13133821d033d2', 'e45dca4e6bb2de2885faf2c225db6bea', '08c3c3320bbf6c2082b841c5424e851d', 'f30ea4c60702a67f53fe13e69c751c15', 'c262fa586be29acfe45069704cce93bc', 'cad76a2a1effdf1a27677c31c07db09c', 'fda255b4b80bd65a489416c93efeda7c', '0dea24c1d32f9082157175d736b5c15a', '45da47535fd657aa414960c6b61d692c', 'e720c5954a594bb19ae14695f60d0ce8', '3ccbd49960f3fba72e134b2ae223ee2b', '3fe27d652fa9593d4b8c19a45acdb3a9', '971f6ec90da2641dc3e88f5bd36d4af4', '0f00dbcb3152dc8bd30244f8afcc39bc', '702fd74c505ef611c9fe4c4607ddd894', '10ecdb0aad22bdbbdffea1d576ee50a0', 'd486f5fa292d028cec82f4e1810b397d', '56b10c03a2ade796a6258ef6e0c1fe84', '7616bb3acb8f3f8a77ba1503944e462b', 'd8588442e6477b7a768c5e88463b83ea', 'c8299bcdae18024e6638acbd93167679', '07e573ecd9af3558b9efe14d5fdde769',
# 			'1bb216a703d870eb0493b41267720f1a', '66f6ee6a1755d6ac8ba0cd78bff24aff', '197370ffdb25ef2690ece9bd7dc64938', '67d02aa94f252e1433af38c40d1536e1', 'b331969c6b34febd46fd20db867eecc9', 'bd284a9acef79a586d11dcf578109137', 'b4374a094ee662cb492e5cda4ed7a0ae', '895a5ea8673d9c8c509a6897329814a0', '3b2484003b8c2bf16be08fdf5d12b3d1', 'bcefebfa5ae49a4dea5990610d01a7de', 'b59ae9085c3cdf12d239eb806df0ed14', 'd158a4cdbad1120ac5385d062a2b2b70', 'b191cd94863ebe36dad4040f7f1e9bf9', '1afa8cd6531f9fcd9e7aa184e2628d27', '3f549a09bcaba4c9f65e586e24ae7bb4', '31c1647ed77332906380eafd0ff0c597', '11916a2fe3b216bd2dffde40f8c93309', '7b04e0ee09b02469141e4bcce30dc98b', '281c047561554a5aa7022cf19cf5e028', '5c9ea8a838d4cf90b744754e6f4baa55', 'bf4bf0c882facebb45cf657da2fd4926', 'dcc97ab2c5d1d23b8547fcc94557dc0c', 'cfe89d14ebf4c5613a074b537fc604a1', '582a47c9dd9e7b9175806a0c472a1320', '82cd2891663b77376dec3803c9819ba9', 'c211273717da5e14d01a6198ffe2501a', 'beb11be4e0b75821d926233780421111', '4c4bc72eb1203a70823a7118e2b35db9', '49ee842ba38cbddf9cd2ad751c8f22f6', 'da23530cd8b710fe7bec86c6d2dcae92', '9aedb2e16982469a38b573e744c8a09a', 'e1c8310bc02116adb83a312fa2400a9d', '30587984f41fd9292cfb29d0802dbd7c', 'ee23d34bb830efaaf88aa04b52f4ebf2', '0154c73b229113d3edee6c2f74866a62', '9b4755b8c981fec7974093c1c2b5956c', '984675e7fbc9fa59a10499de2fe74bb9', '5fb2206321beb7bcdc6a4575cb0642c9', 'd811855817b80aff37025b2c748d9887', '9e5df3491b4d9ed6710897d0bf95e088', '85a16644d190abed6401a6828ded55a6', '43ada789e5449eff02fc19ca28872ae1', '69811e7fa43149ad174a2f0f845c4b55', 'ef0f0083e92e55a80aa7800e2414f312', '4574398525dc856252b297fb119d5f79', '8ca213a0afbb4baa389e52782aaed4b5', '9d1028a3d7e52f46d6fa78467de08547', '1da4bb026ad5a294a2c43a087daac695', '5e0bdbdb1549ef8a63302cda8ad5cf37', '7d3d43510acea35dd8f3e0ac2559e3ab', '942695ab826dd97bc5ddbd02320ea1eb', '5c7b0a4c3c5c30cb9f1cbe32a26cc1e4', '06efa6bb56c5b745cd3cf8cd7eda7255', 'f46b112653ab2b3621692620037f59a4', '549e2d8b425dd9e54e7896630b728201', '5f9b6d169cbe57ff92977409e9d8aa03', '86d263ddd5205a6e6080e07800f7ffd6', '284b56f6714821c496f418debb8a9eb9', '5899e599be4e47b2d261433bbfc254c8', 'ea9eee309980146666f2fff3942fce78', 'f0d26aec159dda8fc78a3035620b26a7', 'c4defb041abcab7b84ebd211639e20e2', '380812584e640964efc45b709115cb2f', '9b9c0f278c61e9af068463e03f903eab', 'af6e96261dfb178de0c4e5a204b9e6da', 'cbf34f4207bb237a904857130d9ed475', 'd78f8120eda6e1b9a5c264fef2f30ae4', 'c5195acad8a8e31e375f40e79b401613', 'f898abcca7b582b17c40a3d9fe16bf66', '2b7c979734b678fbd63f1891ff039224', '089d1519e54f167f185e0ad6fd971554', '92797057aeff84774603b260ff6897ab', 'f0ddf6461302394bc2b08f2359ab8af1', 'a8f59ec1840531d03fbe2fd10bae4e71', '8e3cf50d9941f4fdbd67c741f82f5ec3', '5f79ae0b851c917e3f9cb0be8bf82c57', '95cdf1daeadc26de10b8c075d58764a1', '4e37f30e75e9930b71c9ce4546517a31', '940ae613507646a4e4b9d044839ad487', 'a469ea80f8a376af0a7a8479209a5b10', 'ad35ceaa42fc1735c98ebb969b2fde0b', '4f4c206a9df90ad489695ed145361bd3', '88e19f0a85a6d87a88b4edd98001d5b7', '48c77075d2d8ca16f7d33fd87fe594c9', '3a04f6b638ff1e9a376b28bb0fe845a2', '5f436cebedbef03527a0b1ead64fc3fa', '6bbd3aed76b9ed10c0d4d4f3edc3ad28', 'b7868801f9cc4c61f1f973895e0af9e1', 'e647084a46ccba032df5c9ecf199ae6d', '93c0b7ec47cf8f6a0f26cda59ff456f4', '0c466454a89761aa81c4020117d2c023', 'e080da3d821a75879ec3a433169ae3cd', 'ae38e934fdd58ad224a5f501c204bd86', '7fc73d5961babe9c382eec1d190d664a', '35be0649d461084faa5437138a606c87', 'e114036bb21e1a51aeadda4987f90476', 'fd2a02975390f13eac1414c5ea8c92e9', '58b2af1dff59975950e5073c7da08a12', '6486b36aece7a6d62bbf7b64cc44158c', '785ba89c6cbd1d7762ed76450cd24b8f', 'e391445b7c9eb6abc5ac43861e8247dd', 'fce8b5ad923e80c4106d2954c96b855e', 'ef9f952c3a76a940e201f6fe1b39d4fb', '0144c8c3c04bf5a812e0c6aafd4c8c5d', '1033c9cec1915b17a6d0278dc1bb2b98', '7262108c8f0e2e4b0983b86462cd604b', '77066fb6a346bb02e1ba37b63a896f0f', 'd4106287b5ee1ff64bc63d6b20a69e22', 'e119db078ae13490a1410e50953d9982', '672d2e53da89f44ab5938c462c97bfef', '921a3011decaf80fb16fcc0e25df8981', '72a6c4fed2bacb78bf5b34e6c31bd524',
# 			'838b95afaa4d32d45cc211d322ffaea7', 'd7538095d2d30c9f7474fa98f0a727c7', '3e728198445f0aad153aca2f39f80a01', 'c2f631c773176ee78e62d2108a8882f9', '65131f3518857c37ce6dd2416fa59aa4', 'e37ba60a749fc40b3577d9837daca137', 'bbb3631d38910014c77705ebcb02d73c', '35d1ec2ce24fb475737ea318478ba594', 'b4ca04d43d30982a5e6f1fccd080a8a7', '969d5c27258319610521b0647ee3577a', '7539e2ffa2d7224404aa035132d034c9', '4b4ecf233f9b9ac9a14fa30a0ef2fe56', 'e6ec1f1a1c0d92773691b72abe2d596e', '914c6fdbe6c0401b877436506b16872c', '8a98e95db44cffc948054b49f1b955d5', 'dfb205d24f4f55ccd154a0071c254256', '8b6f2e57eeaa77601af8d1eef3049e1e', 'c958878af39b42180c922229de46c232', 'c32e29dfe045a9ed0e23b894387b9ac6', 'b490965d7f81221cbd41bc35965cf1a4', 'ebc1ee738551828e25530fabb65fb8cf', '02add145b218852fea4c53ef328502e0', '80963fd5c1ff1f13d4d57986d4cbc4df', 'a3f9c12f7e8a356b2d24f6b6377a6b08', 'dc115c57cb68285976a4f5d7f6e910ef', '7077c2772ed0bb4494d041d2cda1e809', 'f3ee235702d0d571b699f9f456a5aa5d', '06d5939795e9b955ae727a1d2b43fa2a'
# 			),
# 		80000,
# 		memory
# 	)) |>
#
#
# 		mutate(memory = if_else(
# 			.sample %in%
# 		c(
# 			'689e2fe4f2c39f2d61debc28dc7f5a9c', '19d3f7678832e54aca88f9841d8b28bb', '4164e2a99c2d7d74e82f207eb8327854', 'bd54ab01e2d9cafabe482e9a1a599780', '9092e556e98aee12f34745c3e3ad93b1', '1267fba06e6e935e4f0e44e67ad0fb27', 'aef1d9f8cb18f994a6ffdd45934d0db9', 'dcf79b470795d576f4ccb117f62e971b', '8e409ac82a57e01370a4aafc1f323f81', '36bb0491b97f6f68e9208887c62db37d', '9f85e356843308e1f48bb74e2e65634b', '8336a5d90ca3d5ebd286d8687a8a10b8', '90d922e2e1d076d18a5f8e94ea2873d8', 'acb988c0698e4bef2183c69711b873a6', 'f3e520f63f5c1f64e2309ab58a4e91ec', '9eb168d736ca23167922f47b8817ecc0', '62f1d90eccf4fc7510114cf16994fbf3', '231f7c127d94a6be96acf56e2d1b9624', 'dd73fa64b0c58b82342ff27dc9a59974', '38764bfae0c06be457c7ce9dbe7e598d', 'f5c38bf189a6e09bc53f2caae5a764bf', '8c1dbed348530e50aaea91947c911e69', '242c8c780dbdc2aa410b92f836a6b39c', '6f8f8fad6c50cf4698eed94f61b0e918', '157ba6f8fe27b2a3c53ba2e2bd43ad2b', '62fbdbac5f31cb1f850e0842fc1d133a', '9bab679518e632f677e4300f679b26aa', '7fd2f89f8b6af4dd35841cf4907c2c4f', 'cc67c7d846b757b90bb8a3d7b749e651', 'a766d82334f8dfd136681eb4d8bcf5cc', '6414f1006db2267a5c7c75f511673335', '217d04d1d8befe380fd66f88edbeb29e', '7e3c4bc8803f84bd2ba9b588562c88bd', 'ef66749eed924166c7fcdd327d8d2afe', '85cecd58bfac60af723eb21050b38ecc', '83bd03aecad1a2ef3945b25e0bfaf984', '263e962c9233079206aff5abfc63403e', '35b394d810435138d161a0b311c88fe9', '7a5b75acebaf7e4a04a92f4ebfa1c373', '18b79bd224738a578d66ebc740eb512b', '8692046b7e3e94196a83583e14990bea', 'ff9fb40c9a7a8c2f0e02ed7f68dcf311', '4a95ba17973e4b28cbe97dc426026267', 'a04fcc44f3f5b168e7343cfc50f53a2e', 'bb3c4c2a369e2f537d5dacee8df82d6e', 'a172d1c935f38f72291eb0f10f2b8ee9', 'd1e726990659a8e20cfb103dd8bc5c91', 'cd2180a122059d6e15cfec2841bdf38f', 'f8afa07be89ae36cf26ee3b347f318b9',
# 			'16856c8cb615fbbcb7415e9524a900fa', 'ee69a19ff904a4ddf2e703bfd324970e', '7c121f3326b1816282a02de140e3a5ee', '52f420c93854691e3a8af76e4ce49e10', '7d72659d46e26e423f61c49b4b956921', 'dbc532f4a3d055155d52b08690039823', 'bb15e8a68afa986ccb175f5d70789da4', 'ea9dadd4afaea5e64be0684582d59b06', 'f4ec1d626a554a6ee9b5be23e1c03d55', 'd2e4bd12dc834b1f190812b5cdc5b9c1', 'e4d85a0b3a81fe2a1768eabd65a73d05', 'e5433b7d88222f82398440e5107620a7', 'd051b045c260bee830b325c6bdf75914', 'bc8698743f82edb6dcfedb88cb813615', 'fa4f3cc4d96c88c57648632ce0259aae', '60cd6e2dd59919edbe5bbeb56e8ebb83', 'a9b9d5a85fef16b57a3576bb9280a22c', '38819bbe7c110572a484608af0f7f096', '8dda54b8a18f5149c4b94434df1b3986', 'b04859bd5e3ef34c3479de0e56a2255d', 'f00428a69584a31e39b391392bc08a5f', '8faff4d804f9bc567b35e3d0e36eb4a9', '0158eef8f28ee76d421afbef385b36dd', 'b9d23fc07f59b0d519dc2c4616d392ee', 'd35f73bf921635cf1276470954735dcc', 'c67cd5b36d02b254948098074e8c2397', '729c315162a09ab5b6c52e189f9c6ba5', '9aa93de11fa81a410fb9e9afe918dc12', '60a8882a0952f02d3114212ce2d67e02', 'f79ef27558a91ec1bd3128c376a94e00', '2fec4e9bcab07bc21766e139a5493ca0', '0a27185600a9fabca63a6f2227f0e8e9', '0d5ecb27fc4f4ca6a8ce119e462ee9c2', '27156cdca5468f6922f320f32c51014a', 'c830b27b6d39f4b9ac1c5a900efaa94f', '8e12b9c5faa13a6cec56725a791ca6ba', '808c52adc04f2c51066c18ff97daeea8', '11c090ff60efa7c8f6cd9e7706c847e0', '4d686fd1a68f5957837b214c6b9692e4', '759eaa5d002f6511e98ebe4c80c48c41', '6932d872aabffefb618fa3848fef95f0', '30df500c9def574905f2236c31431cd6', '3c6f14720b4fb0a8e8aa4ca2ab5e6fba', 'ac60046fc1488a1891d9fa649ab9b410', '9735412ce8cdc3f9fbce1d7aa9ce92ae', '4eae17b5ddc549fde08fd8aa21361124', 'f1e0fd0477259621712578c9b3cc9a9c', 'a80a99bf66a03eed56dc15cfc5caedc1', '1477f4bf1070792e258f6d33b32fe9e8', 'af30307f978f11c3076015021d8ab57e', '4b94560b030a84d588593be435f4075f', '8c83183999fcec12d2a25017ce2c3fa2', 'b694e15768c08f8d384fe6312d4a5ab6', '0c41285ea7fd8d13e230fff8637ae3a7', 'c583cd4eba7086686ea35fa85d330127', 'aa6064df029436c56ee196a341e68918', '05dee6584fd5b8e8eddd08fda73351ef', '3c2c4d0c7243084da34f87557a284c69', '2ed3c68fd561636c35b0596fdded52a1', '8cb67a6aaa3be6bb5c06908e2ec90bdd', '84e8a1dc7403ac967f31c1f136b9cfd3', '2c050f979fd58423f4ff7894b46256c7', 'd452152221054daf6a6e288837170aa0', '7a4c235208d9051eca0107a9ecb3387c',
# 			'6488ee75a1e7575e2786bded2ae4ac08', '4cec29825af61521d9ee1bbc2e56c62d', 'ef9dc8b84a1156159c4f7d6cca242ce2', '584f3a8606534c73d2f8a94d8ef47e30', '61ecaf7641bfe6467886ab7e1e0bd51c', '9427a3142161e1b0058894d9e4cc361d', '606a233b3b4120839c67ca8f98e0598c', '8bfeea44e08f638f2b8009e076a4afa4', '359cffc3782d4b1defc958f0fce9473b', '6608a0bb79fd983ec03ce9bd050de3fc', '683d2571f59afe529e368da92b56fb6b', 'fa4b6c7c779a27b5f6e548b7550abd48', 'b57b948ad8a8907ad73efe414f2080aa', 'b587e9697bc27c3b097f45bea130bda9', '3d4884bdaf2647e53973c42fbe7a6180', 'd19873d51a6d03a90eead12dd048dd04', 'a9ceeafca937aecaa0bbf7e42959a6da', 'ba43db01ddfe51e5f0db4952644cd2b3', '6108e76d0426336623904c06bf694e64', 'ae78751bcc63408b29b318395213d336', '26ff2fdd9b622cb0eea18c62effe8eba', '7358bdd686f5890639d66af3022721ef', '7aa46bb4d4a27f4b54d80055c8777404', '65890742b5f9bd26144b00a3d0bda5d7', 'df50f68f8ca113b60eece0fedd089778', '0911f93fbfaa5a0e1550882a2dbdc9e7', '132ced354118f9afaf36320416d130df', '821847ee688b358ac585dbf3e4aa1a8d', 'c827f84f4caf4e0b70124284c1958cc6', '2473cd294b5fe7b0c7de835c8d7e21bb', '523affd6e132301657173a749a643c72',
# 			'69311cfe4523c313d3a84929918fe877', '77735b76b110b9ed89527be078987fd9', 'e3b422e2eca2385887cd23f80811ac42', '735d54ba486f680f1552f26e10e133a6', '73d4159a875b3aadcda3a298e9006c42', '7fc4ceb3cb765b414e76b7eae818f46b', '0d7f7724606871b4636693b98e4f7b64', '0e420fc1d26607d0700003cd11d45caf', '1053e5f1d26ad0543fa0022f2bcbf997', '3bf4d146ae443a5860c90e8a729746bf', '1ec9debbb5dbcf19e9d5a3877f886fa0', '19bce7e9aa6b793e98c7a47728597f6e', '308d9bde9dd8c25d2629e278f4825771', '4a91816f374888f68d7122698c2f1ac0', '7bb07875925b61729ab9559faddc054a', '9c36e6e73504064318b6d691aa37baf0', 'ccdac38793774afd2e98e8890272df7c', '8faaa6f8af463a63597d8121eacdecc6', '47042491abc1d3e7bbab71673b2bc32c', 'ea9e5f106c6b736bf36c2f81cd49f999', '67693e08581aeaf96841a24aa7a3caf7', '17481b1748b025b810dce5897b8b000a', '9ea55006e2ff59aa14c9cc56090d8a2e', '503a816bf98ba16c00c7de29d6602e40', '282d8256d8705c0646354530eab81a4c', '7ad84382d4e7e80f04d0ee7994509b30', 'a9b371d83d8ddb716d771beb65adc5bc', 'ec35c182aa5531a7e2db10745de8a5fa', 'b2b67d1a81328b2c1415b25feefde16d', '590cab17d2f8f419691dbee1c4e36991', 'dc10cea2f39c778ce7980b92abe8d883', '15f8235f7ab28bebea4b37aa334277d7', '23c0ee7af253a75bf5d72df404cc5144', '2a4dbeeab62c6b8777fd28ab760cb7a6', '10671d5be50a072c7521d8469f513b5c', '657edcd5bd1157f63649d41398ff1f0d', '438c4494c1a4c9572f2676769dc77ec9', '7716e6f84648719ba6950f3a83c55522', '9824f371dbb5dbb3f6267beeacf5a101', 'e7dec7773fe6eab170b8799c69c0c592', '53e3adb69ac48332bc778f6d1340d435', 'dfd2691328f32d5a46459bef287688e3', '4bc05635ff3b18c7b2c830537c879246', 'f666114929ca77f25298d43c12e3874c', '53851f37afefc2cea239df14e46b45b0',
# 			'fbcd4cf5431b0c232522c388b38c4c9e', 'e8ba88459e9ea2d9b0ed7fb996686f05', '57111e340930caf0636899d8c0a9c223', '17c3fdb433266595da95cbce9b2f11b2', '8032f5428b5154a419cd2718c522e955', '8451e1bdbce25db287d316629678dba1', '194615eb6e412cfb32d524e10afbb09e', '1a2f47da0cfa2699fbf64675c850c6a2', '3d85108b509cde96dcff76d882477f2d', '805744c13253005208cd612e54963a19', '46bf9b4103d2e1e4686c10c2f095985c', '7fb65efc3eb48dcf59971316344cb93a', '3107ecca3bede8beac663ff5bd742d43', '607ea8e755ea127ce962aae1a6818d82', '3d2cce5b92205843e38d8ddb5d53671d', '3958f0d67f4cc0a5043bad82388d4014', '19a1776929713c4f42c1446542986ff1', '0aa856d9366067567e0b6f15adbbf2d1', '287840b912a72ab6203e19813e282eb7', '551d0f75256b5895f78d26091512e52d', 'f35dea669896e7562d67b71a7ac9083b', '0b1ec87388231b4411a929de4ba4a3aa', '231f91a3c99d48c6f8a002f3ef4c71dd', 'd2b28cd2140e29368e13b1bc1fc5e679', '061b81f5d5747246fcb39a49a9b7311c', 'c722a2921af5301cddce975ec1d29399', '69dd6ca302ea2a73ec91c656b661a732', '842788ce04d542928143d39d287a1e22', 'ba787289bf24e199e73d4694288ee8d3', 'cd5cbe3cc87d6648c4140103d90f781d', '35e1e70b055329b2c75a6ebd5fec0d4f', '4843819cfc2f4c8b0bb6fd8c0bfdaa81', '669b150e99c198bfed8a6b8d0940989b', 'cbbf2927b468f9f2512e839ddf0795d7', '58a2d44c334728128b66998c49e7a04d', '593fd5c6c79352810c899db60e3a4d03', '146eb1cd64e37a7bac1b3ee32cf764e9', '2143dba46b1d72ccc97b9c28540f47c6', '068630865a4a7e15b8af58583dcf1bfd', '3f34656a7cb9f0c9aa79f49118cc4406', 'bae103539266b152969e88c83df84133', '983caf77c0a016850c1da53d9043fc3d', 'a8f956a295a04b3ab0182dc570cfd6de', '4d4f7ee8a9ca5d185b5c559008fa3f98', '79d4ba4c5baee04ea6d96d4d877157f7', '7e809c3a592685bfc02a153d1b58a4ac', '12f18b195099917f7ffdecfa6e9e2e1e', '1f25a359ca0db51ae128579a904f0a67', '479e71cd466431ae1477da33aea650a5', '3b9a70ddc33457a2c2a5dbeafbe00385', 'dc7d112c42eaf4381fe2ef20143ca180', 'd524ce7ce5d3c92ec3923faa7ffba8b1', 'c6cb9a50fbb25e2775e2a866a1bc995b',
# 			'63908286f52b2be1c780f15fe954af2a', '80507b531a4665ba331ff13f7996f2e0', 'f91661683767b3f77693f063f2f97ddf', 'f948fe03ff4362d25e4bb8fad5ab09bf', '9e114a8e7929e492977a8206278dcbc8', '183203db22091ba19961f54588be0121', 'f20d3245f6f4f4ce3fe0390d95eb4673', '49fa6195df1ed470397212fd34b3f393', '7dc09fce5a1234fafc2ef34ebd91c919', '5eecd1173e5b980fb5925ae91c62ac80', 'c69ddea156ccd947fbca842f4baf7e3e', 'fd1e23a9014980d9ce6de919670f5e24', '8172e590be538c5a84bc9e88269ea299', '60f50373928f0f30e6766b7aeab500f0', '0475945bc8c26467e33d5621043accce', 'e28279300335b052e6d50bd14905e909', '53522026c0a0fadcb6b74db7fef4679c', '4b4202b9ddae07bad7d01cdd228b411d', 'fc753b6ebf4967d90a92fd70fa26998a', '53db7a7b5a96b4c4cd2400b6d7674930', 'c5dc8c246d6689e0e8008f41f29f2067', '87c8ca5da146d10e3c9bc159b5a790fa', '3c7ca2907da4b617a421fce253057a1e', 'd0f90550d0b81811a0211b7df22c1508', '9c8fddf33835afc52cbae38a7563c080', '20774bcbb38e775f2d75809ce26281fd',
# 			'd793a8ebe979af000e60d4946e47e271', '8a14948dc608d9bfe19e1472bc9f24c4', '2abaccfce0e8b76d5727047325bb3a90', 'ab414a73886f2f055ec5a8e209280600', '5587cf724aa577a6ab2d208047d278ce', 'cbafdf4c2f16dafd614da1031e732de8', '160fa00c844947d41a29663d891b1809', 'd5bd8e5a7c5abe85fc821920c4db4d73', 'c757714fa8c31a715680696ea3683efe', '86ad071f4cb74c1fac7a794205d0db4b', 'bd263fc996c36a4d9d3f4dbf1c8306d4', '29deec212cae20f2346de19f6a621a41', 'edff485a622023271524a833483b1aad', 'fbacd44361bc490edc8cb8a698f7cb39', '8b8c878a5c4cf57f8a15d53052e0aa02', '3936c020b47397c4704fbd09b259ddc7', '493896a085d03ad4cf74c1f948c07b1d', '9ddf988f3de805300bb4225de8a79930', '7294f041b2a2c4f64231da8f73bd3ddf', '683c83c697fcaf360a43d7b4d7a3b6ba', '7c9bcfd8c2bcb06ab804da0832a5376d', '7325bfcd95e8c7ff96e178727191688b', '64b29a8a2c50dc0289c8140a6594962b', '77687f9acc2f9254e9c33fdc2e46826b', '95ccef729c9127ef72352a1ed81b091f', 'fb1ad0f449a0a18347d8787976bd439a', '3dfed3a04b224f2ae7f9b62852ca57f5', '5e6de4f78b18a6aa5f9415b651f5486e', '9f4d0158cef9e54eb3ed01afa07aa257', '9c2937194382564d05f49e2188155967', 'd2de66136e8e661aba56324f03848b7d', 'de367715306fe5dc5ed917ff2307d1f7', 'ee3f4a86443afbaa07d98a441829417f', '6fe5bdabc685d1c69f328d8511d2b89f', '3fea07418dca160f6cc53c482093eef1', 'e5f960188bb50e69d28e789421f7c74f', '3ad8b17606b943d35eb55bbca731491e', '1e51ef2741bedf4c303a055d5c3d8bda', '9eb15b5ab59f9ee0cd4a0a9d9adabdb6', 'f51497c84564a7e5c80c9aa5a849b81d', 'fddca2d784d911f710a9c99dfdad8c90', '7a997e8355ea4358100c8a9c9f3424b7', 'b512a78019e243023911c348d3637c3e', 'c5c0acaa7f73130dbc5d27c3eb16aedd', '1fa86f3e27f0fa7d8ad93c7771888290', 'c1cac380b9c8d7b0b7dc77d16b340b9a', '2eb1e3cd17ca30bf98fc22383c367fb3', 'c6b174e91fa69716894e8097e3a4c70b', 'd02df4536b31f44af8ff85c6b4ca23d2', '762a74d90768a2dda908b41362c2ab70', '8a19a5385b4b8bfb4f710d7c6720f410', '14163dcc254114aa979756871b8d53b7', 'b4ea8cebeb7987fd49afa645c145fc69', 'c55fa1a11f8b6c40deb0d0015869b1b4', '2791fc81737faf39bb31f10659c3f67b', '4e697809e61bd497ca2f59707ff97d4a', '657439e198dc6c998cf52b438756ecc4', 'd2de826588f969994eebd3ba095e4553', '2071be5790a86c028ce9799ca39d51f5', 'a0131cbe499682eef0a085f4806be8f8', '95665e45ba4588b42014c5570e1b1c26',
# 			'13ac23bee449badeec2d9dd57881ac73', 'e3bab5f6e1ead7507c8e53991b67be45', '87104449bdd389828f2698ae28f4c27d', '90bc4d8e1c7e78c0b9a1943c5818fb69', '25eff255c8427fbdbfd284b38d6e3874', 'b87528f88fb85c53d95373fb093758a5', 'b07f68caf86307dc53465ef8a53d5c21', '136077ae0bcfafe5f1b0407c764ea3b6', '8f2fa9ecfaf486acefbd5dfceffc943c', '48ad45d4564bd9075e9308f151c68575', '39fce876abf23fea62cd6df863cc9a50', 'f8a036d7996db41d0b8201a0afd6f1f8', 'b2e492d5059c597ae57c8c04764fe267', '4f5e01f7c989c197f9f2e89505e9ddb5', '4cec55036f6adc97fba828c57b874ab8', '108352b1e2d6fefa70aea4d3dfb89164', 'c3373568986b4b8ece1cedba78c3bcd4', '437f42b8a41849d20d4cc298309d3c41', 'b24125917cb9edaf6d36b1e5a5127835', '1f107cfc395a612c72f1ec15805272b4', 'bb1451c2777f80ac1dddbded1ee008be', '6e9dfb1ccd8493b9b0e7658fcfd3b42b', 'fcbada6e796bb52c7bc3b9cef6532b1e', 'ff612ffdd90b7c4a082ab85e9b54b924', 'ad15eec318cfd87d983188f5181615d3', 'bebca63796843fb0227dc6c63f817e4c', 'd7b2dac76f927ff98610b054ebc0d161', '39d3c08cbde7b7c4830c3aab3e0ce00e', '6d812c89125c54cf915ba8330d74273a', '7a1c50a4cfd567e8559ad46bbd01c1e0', '8bb69081caaf38a3abbb4407589ab5b6', 'b93d5a0d64f34aada9d372ca70f681e8', 'c265cb6e68b8f747bddb10a56fee19c7', '6e9d4cef82b994569d2c98ce75218743', 'a77d2ea6a66417cf8cd63e7e726cf5f0', '078f35a53e9d14b71a4e2b716f557138', '604e2a28e8ac778e680ced9a5af366b7', 'd14b48f76e55cb248f406b99ea24733c', 'de3573bf488a75fb1856a1c12db7aa19', '6fa092e25059ed6443f748144e9b3fc9', '6327cd460c7e5f3b50e8ec07b45389b8', '24626f60d5ce2eca2e7686b3581b148e', '8a9ae9e2cab29b136b073df48c34864b', '647dff0f0fecaced829890dcf369a60a', '1f7d2052a921728c39d8bbea3de00462', '1ac471d4e77b02d872afaccb6bec7921', '78f8b43348951cf4be55e6dd411a98fd', 'a232ee361076b8092ac20118b6dd5aae', 'cb899529c5bf8e6db8cdab2bb24ce0ca', 'd6e5ec931b6811cbc5e1868cd494bb58', '5313d20f92f9c46db03a7cda718f8934', 'b324f464562cdbb610cdcbd141890fcc', '7cd9204e50d1b12fb1884ab8b9924960', '84e40de0e873770795f413a3e57aa6f5', '82a28bcaa71de6b4daf8a43658787f5a', 'ffbfb187f9d7e743a74b03f30d819d34', '9f5074dbb6fd588e9e4d65b46df8059e', '034560ecda705b95761efd00ff902523', '40a4fe64f35e2596eb6442d8dcee813e', '6026be9417a74ccb7f6df1afa4493386', '6ed3c4afee0525391602b2771f9a42c0', '8a75b4467262c50d096e9b0d1efc895a', 'fe10596283ef6fc41caa95683235aab4',
# 			'b8eafa88efa0e3c600e36b52a7da3e35', 'a4a3a22a8c4f953ec0c9ae7648f941c5', '73ffcdfb290afd536614a159410c6267', 'bb5f7468db4e3110f3399e5c2ab09350', 'b7d54c16cfad21869c8166c410a62e5e', '9b7a92b9602d135d2b86bb799784ecb7', '8732e1cdf0bff2d809758ad7cb8c1c15', 'b7f570db0649befb89f8ee7950300532', 'b146365e6c076224ebf3218ed355a6ae', '486eebeda7bdebce5927d7918eb12df0', '25de28cdd79d796cfecb3d3180e1c677', 'a3f0045656e47b58bd07fa3f33f8e35a', '97850f812c900eb75855aeb8f24cf1e4', '1258fce5f06ae310755ca14edcbd5860', '7faefb52efeb26aece6a6a9eceb969bd', 'd23e3a57e2c79043bb666febaf39ef41', '0b821da76fcad110fcc73cd73c527a4c', '4634bcb98233fcddf7e939de668d0815', '34d5b1281b1128e7f5d5810f86f34e55', '3afa866f9999f93c780d32b4d2e72211', 'f93d0ecf04927c9e7fd69750d4e40e6b', '7a62486e8f1eca04e01c476b0353b1ad', '988b07b78929ebae48c503fa13bdd7a3', '442cac45c7750a9ceaa59689c9a7394e', 'ce764f3c0e6ec1020d289861bac77cb3', 'd30b768928dc0d39f4ac36b32e1e1de9', '18538691d79aa33fe7205443a6a2395b', 'd164c9aeacb86064f4e7a7fc38f3acb3', '116cac0663eb1b7dc79e5fc117f14604', '8b2da321d5bbcc72efd341b08a8473a7', 'c2c207758bb3756a76f3ce861139ddb7', '8601a2e330f2091afcd6604c4a961049', '399de50799f7541555e416e60881978f', 'e50108e0569a7ca02184d0afb9aa8066', '30dd81046c1c1167b12d62599dcded6d', 'f6fc2dd3857f00a564ca23e6a36b7220', 'bec74c909f1a352c316533391086bbfc', '022507a451b0826fd0f76eb05d9cbeab', 'f0f1e3a73b13ab43890f2806278921d9', 'ed09799dad178ac677b7b7121ce98ef4', '0bc6cbf92aa78ac6d3c99c6b4d83fd62', '5b95e164f42b29e274fbd9181b7bc7e0', '525db58901cb5597476ea861a9df8b4d', 'ad312f753beaa639a79e69f156847f8a', 'c692c0b6ffefb05ba35bb5fcfe6086c8',
# 			'30a0cf358942d9239837803be519d3dc', '64e9644f610d3240ee218d079e7be076', '53af56af1f51dde4f4ccc3e971adda2f', 'b1510dce5f7b90905c8e75450b2ffcd5', 'ec535d09723ab6fe8c2f093c0097a61f', '71f9ebd2b41d3723321fd570a519908c', 'c07524366a6b35f60e17d34be98ee274', '6636584d36c2b4a867b40e6434a777f7', '7f1798011b137ea0337110a12dd293b0', '2bb2ad830713fc3d7d1bfdfddf4ff742', '068502277538ef5559154b543167fefa', '2dfb513f11733d86037902507e3596b9', 'bcc2fae0b0f117d1780510345dd071bd', 'be76f55ba4811b09e3654742d27944e0', '4926595609fed5f240370352c9ddfd1c', 'd0ae054709c85e294f797617a12edfbe', '8c44c41d078d29019e70a96d15eca2d0', '4721116c52013a5bbe46e64b3b666f1f', 'ee90f07234a617acac63cb663eb5e170', '279589794ee34a1904fe8c02733abd70', '890a4db4e60dffa4ab2f812ce40bd3ce', '07605571f51519f71da03704f056fa43', '128f36778718940a3a0be9400f030c67', '9e8323fa01668d7ed82793614940a301', 'e201e16781c987885e5331e2e7dce990', 'ecfcb3d86eb1cb64ce9922c2a44859a2', '880fb7cebae5b2c3f7c3ba46c495feef', '929b442e2578211b95a6eb1588ea3439', '4eccbd6ed6b811dd8e99db279354ab05', '1fedbb52b66a0737007c06e23fd89c77', '684b4e810cec409055647170b38732e6', 'ade74465ae1905fc103f7c98b77444fc', 'e17ebe73ef7e40e7a1903a076654de9a', 'b4f6e5212241973692c9cc2f7aeebb3d', '38b2299b9a0c8af0239107944ac0e230', '15381839d4959c1e6fbf2349d8922f17', '924da3840f84e21148b592ad1b228773', '82b7ad989ccbfd970089614ba452dd93', '502046a65bc05dfa51c4585d03a61395', '30ada5d6d2708ee18d6f647d2dce334f', '26abafba9cccd1dc83e4c0eef64f5b08',
# 			'cb2d45b523a31d3e3a33dab5dc0bd342', '5ca4b7bdf5dd87ae700f664dcda51d40', '88ca1f6a444a590e695a95e763ce6dc3', 'a777ed3acf860ac9aec95d8b6ff2c694', '168a1b67fd9f6449b8f4857baf9345ae', '29348c3c795926ca78107662fd7c28ed', '8ce3eeb470bd02ecd8d041c4d0bb534d', '72cbeb4b127198a71844fc0e8dda316c', '176b41bb67095ba0c0e7150d8c8efc71', '31f32214c568d0f225baab2de1b80d58', '3d2ef9fd4c49b8eef3634cfdd6391ff7', 'f2e98c564a16be22b60ab56a4e272344', 'bd72dd64cddad9218397a1cad2f26d67', 'f18fba81d42fe306475c95a239b675c4', 'b4d313f3302fc4629707066eda6b754f', '779ec1fdd7470c03ba168239a3007c04', 'ea42aa05125383d3cc5695265cd88dff', '6bf432d7eb3554953068e64e8a8990d7', 'c809d99ea8d5c300c77329e095d2fd17', '3d1d7eb1f0c80af52deed172bccff1a4', 'd913c483ad905addd0a5f4a35c330d37', '9ae08d8e57c6a5283bf016602cc6dfea', 'e7d1eecb58a0fffff0436ede34314ca1', '1119418eb20aa622f651b2dd31502615', '40595d9dc2c422507c87e62bab6eaac6', '7036ebae2a9d3368317f628334d1fc11', '3921d254ac80cd6b93329cb516d8eba8', '5c9224ba16717443d72af3498155dee5', 'a3b5cd4f36995fe7907aa1d023cf8441', '1a02601c4c02557aa72c9546db551fd6',
# 			'df40067f3cae26418b89a71a7d4d29b5', '73f506fc37a845d22878b140692f2561', 'adc9340438b76f948f0a92cbcea0cdd4', '741f0187699753a8d8c81f7741f9b589', 'ffb6d27c2f5f036c18812ff399c715a4', '5c15ce23f01a43e86d9893ee0cae9d3e', 'bc693f37b62dfe8594b69eecd00c1d05', '9f9fb6e7a6e295c40b9ba12a7a3443b5', '53a8c168b7b7b1dc671969b1014c93ff', '973d0ebb6f9431d5d012e2885a996f23', '7c0dc71f119eb5e1be9eb6712d5f3851', 'fdc5b92d95c4405b8a3e0056e2dceaf9', '71b135ad221fbff624bc0219d78d11b8', '12c6ce21b31806a47b58cf2d90b3d43e', '591608628496c6294da86c97e3f4fe4b', 'a9e0ebb7f665e1b9a2f10b21af0206ff', '92992201a3a7b95f7e9c3f4af9b6eaab', 'e44d7788282cbd19a5ded39114fa42dd', '0ddf4aa4b1405bb04ba3ea7a3d416925', 'cc787400f9142ae15d52c27f5b8f6b22', '5f634c920bb17b8ed4acb41d7c7e3deb', 'a3c4783f2a3c90b6cc5ba7f070cf17d4', 'd5cb723a644d58765143fd3647390774', '35e3a321185e38f1b0edfb37eae1ba39', '60a7a1ffcd708be405e1ab2cb0fe7e04', 'ef15e5f4c32a7cdfaa08924e87af29ac', '3f64d6bdc2b983fefdb67e0969b04bb9', '2c349a2c4c97eaf11f4aa3870a06d15a', '479ffb73ccccab63932b84d7110ba1f2', '0d16536809da52a238eeb138e14d0a8d', '380202d0201bf37744d11e8184a7b669', '0d99c27e1849aed69724b21e5901691f', 'c12cbed57ca1f9eea7a7b2026476f31e', '083b0cf8716208f22afea9a7e2132f10', '6c2f8c82141693303a373380606b2393', 'cfa0f5a5c0506b4d35b4bd84904cc819', '768aa942002b829bfc42d997f5a3d81a', 'f3c9cf8c3294a27bef449a8a9c39ec66', '82b17993ab7f4833245f11e4ee5c7830', 'a2e6d6c6f82e6e4b79d99e7eb9aeeb5d', 'eadc546e0ddb1e9be72a132e735b129c',
# 			'b341d4fbcbe01bee8bb228daa2f29359', '6a793ba5e2f0c40c3c0dd5be4851b4b6', 'b03f48a45a0f6b183d0538f6d69b0c90', '4f61b475123e4fbe97feb73f499e3ab3', '455becd42afa4abaf598a148c6a32c90', 'ef537a9c6dd50e1d6cbd6bc1e8ff2770', 'da50ee1314d259d59814305a5daf567e', 'c4e030cb0cc2c9b5f8c27cb50b70a1b4', '7c9a311a483f8e09e855d093a64f1cc9', '13a873ab94a542b7b81a3c6893f1453b', '14b65202308bd66c046f9b95c211c6a8', '51457a98f37f06784c79da5b5530386c', 'c34e2393c3962381ffeba9aa037fb7c6', 'b783e0902bbc61abe586ed728c343d35', 'f5f7497a5b3fe75b36be3d4e8d9ad4e3', 'e9bd342f1bb840a5cf487fe5f386911c', '5b5a9e5f780491fd64eb80781b9dfb1b', '0d5dcc4a342a5d0fea0a27e165270997', 'fa054f8d8eb7820f92811ab8ce3e44f3', 'd36e71db61f86d9612d4bd73e82e08bf', '62d908981e6e58f8dd59d2cac7a34d8c', 'c77278dc29dbfc8fe0260fa58b3af135', '43820d50434b8fd638fc4931f9cf89ae', 'a7ed24ed4a96da81a2d6560c13b26f77', '98a5d0abc4017c5b17849a114fd4787e', '71b9c02e332f0ac479e6e7172e6f5888', '3065c3cfa449d9d1c6c91657c8106018', 'f58b97eeca639d9d5119588ca84ea4df', '85ce949fe36353520a30a26da92bb13b', 'd096f7f200026924a1db67bf90eacb1f', 'bc181da9bf2de29fa3640248c38c15a8', '2572ee5bd82a3299e9c3c8324dd68a3b', '931fad2c5a44b3accecc3c421c4461b7', '0cf18f3fbea56386edb11978045a214d', '0003023eec0b4471058298b434b38298', 'd1661aabdd049ea790c5b8b96101ab85', '4bcf7e0df28b337e1daa8a5dc25a28cb',
# 			'6e2bce06b96d1ad30e9f4c9cb305b8f2', 'e80bf5578e5016916b81778ec620a3d4', '700adba2c8d96511b51a1ac9c174ff25', 'f86bf654c4db0c522c2f0ef84e410e40', 'd275330a1440f1f895d5867fe541004d', 'd34db387323f5df5cfc87169884952c2', '6193f167b4a2e99a8e2c946666b16766', 'a51a953566fc8bd30007072361e73c16', '10c7fd00aab209e3d4be40aa78fe72e4', '934c02a8186915a4ceace1272b51043b', '54d0912b7aa0c998b0fd396155191122', 'f6bbb73dd6b055b073994c4c508043cb', '8119935d661d7872e93006272d640d96', '721e62bbcf02084f101fb76c7c4f3095', 'e22d7bb7b5fdf9dc5a559092767f43aa', '3c0e61ea037bc2d02485f41f988c8183', '199fc3e8f6bdd47d9aa2df2da727eb8c', '6583e92108ee0e8211c6760ed36397fc', '1a5d0352b7635a7c137fd411e1ba4fdf', '6d994f46fa8614d3d2e20502ab966798', 'c26fb294bc2bf68ccb8f9fef939ecb16', '9c91641545741373973a50e4f47f3da5', 'd7f81b318b393309a51af5ea0f179487', '4c3099986b0355154b705c38591f366e', '5f8e498bf5063ea0c67a02e251bd0c12', '68549332895e288ff09fcaec91f1255b', '28dd0b4be13706392d454000f00b9213', '6d14792ed301263dea028fa173531ac3', '0ba1614bd319f2e41c70bf37fec5ed97', '9e964d362c9355bf149826657d9288fb',
# 			'dce1eb7e709afa5f1fdf2cf46653f3f7', 'f22be65ead218291a08f507b2612a082', 'f300368f904a98017f3e0636b50bfa36', '8dd9089402af66882cdfaac43be63fbd', 'd11d50c1047eda4a02a258213b47e72e', 'dd45427be1f3609873409da0e3d9438b', '4b95deb61d2f5598b8459eedb786b77d', '2e61d9836c1aa5e77e3c7357034942b7', '602b4732589ec1e9952b3aed3e5c8b5c', '3c13cff5115e7590cb1d642c7bc5eb94', '1eae382e255ebf9d9c039e6d0a45fb24', 'd546ba5759c0f0738a1ce7fc5c41f808', '828d4e3d3dcd8de36fcf21fdb0871112', '5cb1818c19de649ec33b08d9139bcff2', '8eec49a4717fe928491ac41fdaa82c33', '6218a8b7233414c51cc44ca3dd1fdb54', 'ff6e3741699a36724935bffc0f399155', 'fb15748568767d67a882e746821b3bb9', '53d57fbd4f460f1e80a295c2d7f5c8d0', '9089716efae8dd48f19743717a22bf6c', 'af610f040a896320d6527261ed50adb6', 'ca70d83f2e1df93a98499d18230cb4f5', 'ce3dbb49a1d2d56bc86e67f3b5cae390', '6aac00fa566c08b03f8bad96a1d7d384', 'c6cd2ac1761bf9b06d7c2aecdbd6a1d5', 'd6a019a67f6849b85c4d461bc2ed04d7', '098b2a78c7ec1b635a8e17b73ef585bc', '3018a47f041be9c166cdc31896f0729e', '8fb6778351ea48665c3ce16aea255283', '11e3451fbc0c156a51b150a0060fead4', 'f3d7fb4ec2284f224a31614f4624127d', '5c76291652e22d0f0a3905b7259c8ef2', '388879fe2c6545498257957951703393',
# 			'81c94e4b89edc3e532246b6cbfdddeaa', '08b31ee0d2b377084482616648f7b206', 'f4bcfe29aca42876425256c85fb6822f', '7da7e09b7a953eff3f07c342f378a31d', '47a4a43632a1a59c1dfab00d522e3e08', 'b88af0b6296fc201742c7998961fdd23', '43ebf07bc34905358a0b36b7d074a9af', 'd5ea7d170175f77cd2d38f67aa84c1e3', 'a6c8cb5f921993c25ab0eaeff89df9c5', '4b855aa8379f5865dc9375a9379e74a7', '5d9a90f26f5dcdc0d702d6c25e9c34cd', 'c36bc2bf700402128f9b5caf32bf48e4', 'e607fedee1f91a479d13796ab799df5d', '00c46912ec90806aa890fa3de59d1dbf', '33e1a1af15d0c88c14030b88e3cbd244', '6d9e1c6d905266f6d0c804ebf2eed05e', '40bdc6c9dbbdcaaeb69ce42189b691b6', 'e10395ba857be3c5305d4dcebe9854cc', 'a80c94a36d362176bba212078bc6c82e', 'ce4fa1255a52e21be381273cb9d89f73', 'b3cff34b7d800afea4138f45b7d69557', 'e5e6e07c05a3176ec16af7e8985f30c3', '9d3ee620b0b9d3bf90c74c2cbc9240e9', 'd3f555f058824bb7e27fda8ae4bdcfc9', 'bc81d7f402d542749414e7c7ef279178', '130f31b32e0b040b1f19100e85861398', '1a3724b7c1686934bfe4ffb7f47336cc', '638d004b9ee07d34ff81df6d58f3817c', 'a56a841bf025fd8b9876adf6c8d4d936', '7a414d49fcd29ee6a5cb45ea5b376e06', 'b9edbd874de7d3a111443ee9313c7b53', 'dacfe8f19654a23e865f5535d581c71d', '49d155066a5359e61a2cc7e1116ab7af', '901dfd0d7dfd3a110c4aee8b2c505eba', '3a8ce53aa24a1a02c871fb07ce73c642', '84add38a54a57fd0b78473fd47049f66', '6fa9d73915d914f17253de9f18336383', '28edde07d788942ba6d74cc78793c2cf', 'a8aed070a09cdb26117a53a31a4a59f4', '659ab64ac38e46c6e32171f10a2fd44a', '09cd3a035bff9eb363d92707b737b7c5', '622b67c70869c4f501308efaa92f08a7', '0bf3f575fb60e84cd06e86fd4bcb6432', '411a84ee1844a7e50925f541b56c5e02', '053f6f31a6287e2d4446950d4ed186b0',
# 			'0f7ee754e3eb6725adf99123fa9b6452', '04c17e8735ea716f28383128e01b6bda', '0a6eddf091d95fccb1d5b6660f8e19ce', '6529d70a25b0589c60a824253c8cb3e9', '67fb22348984f468d1cd6d7af2bc60c0', 'bae9604110c9ee5cde031a3b054b243b', 'b0123999731ffee8fe9699a8a4bafe43', '5a731d415f7cb0c8eccb7329c0a1c5ba', '50622c74c083c57f423259361be38512', '8e6810d01b61db79708694f290a42c31', '4076476a9fc0e197925da4fcf830e5a6', 'c988ea9fc763265d3336ef62ba6718e8', '8a6b189eb8b95bc791b8c34f633ede16', '9e39d4a344342662d81c272da29a6a0d', 'f7ce5db51f113b5862c5199a412fcf20', '434d5ec1f407511d4c5d83f3cda3e57d', '1a4728e1617bf17effc16c19b3445fac', 'b6fa39edd95751626a9cb333ab2d1a61', '3aa3036d031b9b2fedeeac2e3b1f0725', '8e491791c33076022f4f32b98294dc2b', 'f2ef80ccbc94bfb2800af86526ba89d0', '2dc9ddbe368ea38d3cf2685ff2fe2fa6', '429dc581bfc940cbe6201791bbaf96d0', '2f293fffad631aa586b5e0653c4d71d4', '1ed337b80c48281d3364494e9de570d4', '8b5dee45785e902d7df4a4a76a3b20f3', '70a021e3c1128b46eba2acb77dc02a05', 'ab2cfc9b2906dbc7167d148b9c6c8980', 'f28d4aea4860ebab83014918ad324d32', 'e657f69a061acec0ddcc5667b5cfbcfd', '2c1c6c393fe2f10226470c56dd76c6cc', 'c23db490ef8a877a0ecb0dfe0027d793', '0b7c56bcca8a7a39891382a8c762b47d', 'caada4ab80c701f04000d6ca02d01f2e', '3830332faefe21a0aa2fdd3c8a46e236', '36c34b7901b1eab58a5594aacf9bfefe', '30eec40ac99f0d2e371db6c077dc30c3', '068fb48cb6a76c1c3268434bf1eb8f54', '9c7fd7eb83dfa3a4b2108b0c11f8b685', '68203ff254df3b2f12c1a76d55bb0894', 'b0192d2f071fb836403a1d8fb135a43f', '306eee96316c9ead9b4dfc215aa1dc3f',
# 			'f3b104a8f147e678859ae13fb1e92e39', '3000fa9b5cd45e9811b676c31869e4c7', '771aaf6d191c32badadd89755e3c5bf4', '21d5b602d349108b0ab58b1e3dea0b68', '8f0c7d6f79486b23591cc0137ae2929a', '9b47430bd23f629eda02caa324b54367', '2c2d6c313748e2c4864801b8e8276482', 'd2ebda4e88992548f142fee0a45a6b01', '7b803393683522309f60ae50b8b5e523', '320dea0549bac5e71a431cd993742dc6', '4a490aea77a4fa1eee6e8bdee956fcb5', 'bde56c0ab604dc59b57ae470660562e9', '041c7e39611eccd375be72a015020045', '6af0606d70e2ac5ab91657448b108fc8', '826761aa819061c76538a21b0019ad3d', '9721aa9b400a5fcba50d40e641c75f9e', '38ff215e668c02f75df4d0dcac28026e', '25312185661c9d6dd5003535ccaaf13c', '3190cc1e5a786680b2b40b921bfdbd9b', '72f414e1e2f2f2ec92cf252c5fe2f9f5', '2246ed072ecdb0bdbff7ae78565e7d82', 'd35cb834cf32f701ebe26ba2364e9eb6', 'ef0882ce45f8a26e3c60c7187f3586cc', '0c820def8c2be063220de106872b05ce', 'a16b3bc812cf0c15e03462aafa704f9b', 'eee05b341d3e375df031c2d76ce92479', 'fe77233f3e5f8bac9bc8c8823a4d3d82', '48780c9d2bcdfaa2b4bc28da1afa93ac', 'bb7e3b1d64573f18f1e7082913ee3513', 'b86cddab52cd1fa21c81486036ea4b89', '21bcacd4351779259e8b48050b6ba9d5', '0276c4561af935b2510a416cdfb55707', '2185b25e59bf2a1c1f9b89bb779a5299', '5bb7deffa340f541424875da9fcf4bb8', 'e5968f0e4f29776075d6414f6074ad90', '0ea63c607abb15576bb5a58e2d0d6a3a', '3906219b97ab774cdfc9ff6792ad19a5',
# 			'6fd75ecf66ea83a271154ba969f0e53a', '987a0c24d60b7be8572df31f3f9b717d', '6c3291c8a2e415830ae0a812ddb74e15', '86c29c6f1f6ce0948a2ce10aef5591bd', 'afab2418cd10fff7edc9cb4f1a94224d', 'c6b0bd89c3f757fd26751880b8466e8b', '9b2254eadf20b66e5e91d579be96c7d9', 'ba375d9b789103ae8b98af565a0f4d03', '3d2a004aca50913f9a79c8007e81ce31', '45b89ec714b959af91ec7d796be38cd3', 'd8bb081e0856e94db81668d9235c8ee9', '2bfd32f8b8607cbdbbdad07b1839136d', '42fe2b9e36ce8368f62a7656ad3d677a', 'db05c347faf29335f46a432d017ee07b', '9750e782e1085296a5a350819f78af97', 'ec002f2253d289faadbdab1f22d447f8', '6a1eda05a7848d150d24d206619f7724', '731a722dd86f184a2beaf51ff78f483b', 'f62ce2fb23c4d74f9dfab4926239b768', 'dea7a674c266aa4f2ad993714e833f15', '7b5ccd10d2a8eb610c03fa2a6f4d4182', 'd5592c4350f1ad5729b1b8cb161db9a5', '1f901df8bcca343b7176f0d3aeb6a9c6', '829ecad900f7737bb0475609306cd5db', 'a58b7515790eb6bba13eab3b9d183442', 'f3ff7e4569de735e33d3ae97bae8c074', 'f0fd2843c8e30d54b794d6200425bd26', '43a4c189f3883a6f19790394a541771e', 'd4960e752d0f496d0b4ab70516f79594', '5a8df6d0c40dd5af8d09aa0706e98e6f', '6efa0dc7b08d401b4eca88bc73c7b11c', '57a2ae2480881f5a73582b510fe99a5e', '3edc55615c5d429c08e633224e896708', '5ebc45815ddf7ccf0bc73da484e2c5dc', 'dbb4947a24ee9d349e06a3a3b16be9b5', 'a65fa6865939a6e98ca582f0c68b9a39', 'b78d82fd92347107d83e8d146b321ebe', '5f70071994bee144b2c72fafbffa2921', '13666e798aabf1c155300d3706977d64', '80d65e511d343e1e3b090e0595cafbbf', '7400b68e711d645907daba6f699e39e7', '664e7ce66b1cfb43d2836030a92b8b05', '28961282fad31b23d02028cd7633c193', '83770a3e74a19d4bd1fe6768a0e6392e', '67e717c4d20aa6f1dc00e2974a8a21dc', 'e2eacb94f324cf0c30fa0b38f5c95e58', 'f7acdd5b4a46f5efa76868cd4b027405', '05f05dd34b78e534b798b829e7e1f346', '2bcf530553d731cfef1d45ffc06791bc',
# 			'e88dc7bd5b53402f8bfcd1045bf6125c', 'c1e9dcf797c6d599b5b81fd9f024bf19', '94c1be8b97d3fc64e207aba4b8ea7399', '52f75fbfa24380fd766b238892a0a616', '90a474be4c1b241f65e1b9e5033afbde', 'a785de17e16b284852549b1230cdc2d7', '23ed1d854acd459b461f41f46482067d', '838335e9c1ec011ffab62f090fe87a2a', 'ec3d5ccb9d1b91d199c847cfe8764b7f', 'a6042c4392e65e0356fdf9ca426913e3', '4369a1c83b19d465ad87632f7209e12d', '4d5b16411cea480db403abc5dd7888f8', '21961cd461436317e5b07d6235f2054e', 'c3bb5729fb776b2aa0fcde96b4e50e4d', 'd147f953e3dca610d8ceef42d7ca2357', '6dfb023992e23d40ac16473ad710ad02', 'd5784923feefef9a95fa3a985f597440', '344fe8a70c6837b7c0ddd6cd16a4c12e', '49e086a72cf5d46b534dcd5fefe313a4', '6fded0c0d1971e694b58ed92901bb116', '6ffeac1518e7bdf3bce335aadc5b2937', 'de87abf02112258da54326de0dad1f13', 'ce21a027585d63395bbf0778dfc2db12', 'ba46da2441ee504afd2d74a99b8c9513', 'f465555b438aef57109348b880a718ec', 'f84eedaac09622af7c7e76ec9c286206', '19beaab31f8ddae3d1016ee77e0652f4', '37fcde04fa42f3e49eb830c964457cb4', '2566f621f7994aa833f95fd56169fade', '73333da8a5af0a811abee65a6e0cdc06', 'd915d15e47c20323ccb77bc39c305519', '974eb95d2350d4b8993447bb6a7756c5', '18db03e2c857de8dc23793621ab8b99f', '1a0e82bb96080247898f4ae794427c6d', 'e0c745425b9b7d784c249fe54772ed17', '4c7342a3ce0bbc081bf217d0fe196422', 'ea16e824fa03ecd77d9b3855dcc578ed', '192a6079bd67276ad0330c8ac9910d58', '43fd73c9428d5e1bbca2d0333c1c35bf', 'fb12c15eea595ea9a2155e5318847b79', '48a5e47dc9cbcb50211ba0c837eac890', '6071132a5bc8f45895e05497af726aaa', '4583223c006a2210590b280e72f31195', '4e85a0b24bc2d2decfae3afe01fe4cd3', 'e72f2c96cb163c20fa8174064a7e4773', '3ee98853c3fb7d3561a46445e1056516', '0e3d8156c7fbb12c2d3d4d82a319e488', '4dd0c701470f5427809df04a24cbcd8e', '43ef64778c06435432eefa69c6fa4db2', '09466587968429ca6a4ec5cb7bf394f5', '104d0575aea44c85af0f3cbdc7962fc6', 'f2b040cc3f902a14e3a232b69e12da46', 'eda29742af7180e99a6109cc758fe082', 'f48a8456994236c0b03d9e2bc8112d9b', 'd2c2eae849097b9b2aeb26fe6dc74720', '6defe065d7d2eb72644a667687183d68', '7c30fb17e2d52814889cb8d285cb935e', 'f0740bf6ee2fb10a9cc263492f56b943',
# 			'bb7b4b463916fd37253f496227a014eb', 'ef819edc2bed64ce850ea8129642c730', '550087f72d0f4c0f668a1e5ca4c786b9', 'ad09070473253bcdddd133a3fa50376e', 'a3b2259c42c66c6aa807792f7c34df97', 'c413fc29a864f5544286435918840773', '1e34ab20f8a588f242abd502f20f5fcd', 'edb8ccfa9f2156b02546824c89e8b4ac', '21db202eeba27f1b29466e73bf9b6294', 'd060d78733d18e6d4a1e91b562bbb83a', '91d9efed34f1b27d595a479d2e50c886', '54c9f3607fe8ead5b02bf14b649a1641', 'b0c993586dab7fc89b06a363a1c266ee', 'd53d7ff9b683701fbeb74e03b5e1c504', 'f596e70f04a7bf47e3d229e692562564', 'a72907a163cf4479d6bd3bab8b2471ae', 'a282d1ee892b1bfb0c5e9922cb6b6924', '9c12025643a6fb437edb03018834b9aa', 'ecc046dabca1c09ad792b321d2d7f94e', '410f56e2050f5410f4e40b8993dbf692', '61fb871e3861e8337c0c4b1f42b713dd', '6f71f619b9dd25ad05d541fe794ea62f', '21b11f3e691231f21171d1cf55e9315c', '7254f412f1a0566492b02284983dfc9e', 'be7850b6aa6decbd33e7e465c5b9af93', '1ddd6dc91c61191f23c2218109f91391', 'ff80fe86bd434ce8eddb46150f6b1f91', '1240fe8569f44a1ee0922929da2d8877', 'f5cac7788fca249ee58aa9f7325c6937', 'aa4093bb5fc5a035e073d49f8c4ca9df', 'aa98b0904e6df3cff8082d51c12abfb9', 'f13ddd5cbb6223a6192c61fd96427e37', 'bbb10606264d135b46fe4709b82242fc',
# 			'1268af5a533b3f81f67f2e88667206d3', '79ef5f1b431e7380a4377686dd11fe13', '97a9ba7482a3b371a7b7d973e3700326', 'c206fb1ef4bd168cc6377de07da93bbc', '1fda102af71bedfc24d0b7cdd2b8682f', '065edcd3258c22699beefef3e35bd62e', 'eaa38adf6dee8c11df75b8637d2ceace', '099c9f4991a81e069081ecad76ba5bef', 'c4b33bf9922ef7ad6a3c4e74878c8b4b', 'ae758a9628cf3cc68c4f756e7782590a', '65e7a81f0f84a0916e8cabc6aa88e04c', '7caae9cf41aae2d045aa483aed6fe4fc', 'de1bfe7a4494513af3b2719a6cb3e592', '75c48f8e42689206934f2574a4a4a5d5', '6d876b8d08ff7b866621b5e7db5090d2', 'b691274928401c9989964c092b3e788f', 'fae445986a53fa1bad5c31569da20e85', '4ddbf9433b7de79ec371023e9f6fdc8d', 'bfe913e52e3640a58a2d45641968ff5e', 'b32cd2bd6be6dbd3af0487ff49342293', '477a02e74f47d20ace26cf165f8e145d', '4aa520a635d7658bda80abd562a3e54b', 'ac5ba35ac29606c1b4399839cd30ae73', '73dd8d9fb5c7365912c6570f032afd03', 'c1083dde236f08602d19ad362f1d8e47',
# 			'18a60b8b1999439250b8b38b43f0151a', '3370dc1fe4adc5983153ddc39cd47abe', '58c71cdfc4c547ff57e4469b1763d637', '2c1bde8d7e6b88a82d031e5a014e3a3d', 'c9db24b33d8096b0995149e5561734b7', 'e33cf59da7508bc9c98677ef88f0cd40', '523c1356d3d77ca8bb46167c18a6235a', 'b9cf18e550ad16453f69ebae2732acec', '8642e37f79e8624779bec58b59f21c56', '179e1bae5b61c281d5f98c14e50279bd', '7dd41592783f1035868ce4d5b2734302', 'd74bbc3466b1685fae74aa10bd2e514f', 'd48d38ed7dcc303e7ba99a221c49d016', 'aa22c0ae9f45a573a6efca9f82e6671a', 'd31aabc9c096d89fafed7fcd0cd756b4', 'b97f487a8367cef652a7161b6c40c6a2', '7f2409f791cde3e32c8d3ba016cfff0a', 'abe27e7bc200460a80f256035843b980', 'f40e7b179cab6233b53f7cee0620cf53', '69f7be6c08d34b558e496c7c34feb741', '9d040d1843aedd8a462579b293d3bb41', '4ea89ebb0de7be8a3eb964add9bf4fd2', '3c60b737d5b3f3eb87a3e3c8e47afc34', '51e0143458d0b507c50e4b47b949919b', '544769483878ddd62817410b1d56b64a', 'a6a3038559430891aac2103acc1161c9', '7dc528adea740509607f70607497105e', '054c210f87b719a9e383f2788ab78064', 'd197c6dcf596c29e169f11f23d91aac3', '2932ec87dc593f48ff9bdcdc9cf02112', '695c230bc7ee3ba97493f9efe4e638a5', '4e7d0a6ac5326de6980677cf1ba5d157', 'be355333ba2f290a01865c636174b614', '6d5c0f1dd036825397204ab82fd8041c', '84ec32f30ba3965c7c6f37a9eff28431', '58d527f35a6222c9a5ffbcfa158f93e8', 'aad1e1f1e353b7d77c7683d642901e05', 'a601e657a84279de077bbce871cbd130',
# 			'6e12bb8133d77bb5648ef1c26bb727c7', '02f84d9d061a4dabb2eb8ee4c670860b', '0fbfd1ef17df548de4c605643ba0b066', '8d66c4f710f42beb51a73c81cbdcf04d', '89de87c5f6ffda65c4635dea62d4240c', 'b88b67dae53bbc321f2f3922766d5cfa', '25e012a55b4733870a1baa956847982e', 'd893216f4c40fafa9a05819b21de9fe0', 'f4a8750062a5b228b047dec152821cdb', 'd5b176fcfa8d881a1afd3e0342c38bda', '460109d09e104c336dd791b87b9ee101', '6e3e682bb1065ec20afdd40df90af591', 'a80073a0f20fbdf5f6595a64f0cbe0eb', 'a52d85cd2218d67d5fe068d37cf177a3', 'f900d7e24f5bd67297dd30ffab3e6a11', '4c6fe5cb1c024e15687b2346de7d31ca', 'ec1aaf0999fe9ad589f6e522611db38c', '855ad257b762b205ba1271767a836de8', 'e32ee3e57071e802f9dd4be11aca61f0', '3cb4804c087ec1ab2fc150c9594ae630', '5335b6b240085a24549cd78b14d72830', '673ae38e1ef9dc7b033a4806bc23aa3d', '316c98876fdfd0e95f6038c95e61afa8', 'ed3f1ca2814fd4ab69310457a85a4fb9', '955f39cca44ec799da56526ca4a674e8', 'deb4c722c1c6e50cba9295611f8f4f94', '1c83e743f85fa35cc9daf90c99bb10c4', '8bac39f73cc773c1ad4dcbd487e7f7a8', '825743ebe2f87f903eaea5217dc4033a', '7f6fd0db09cd45c544731b8f5c9ff75b', 'c22b53c6c8ab422b6464a84f2e82d85e', '9cca066971e8309ada58a1a5b6132598', 'f4dfd016413e162fdb4effd4f121335f', '17ea48f5316efeeb337d58dcde24c9cf', 'f9cb720a25f5250371a4fbe4b5de1acb', 'e4bc74bc45ae6efe821c836c77b9e8ea', '8134d0e949ab00c3c7e9a49afec7bf48',
# 			'014c7290c6b3845173e0cb71083e1088', '48fe23afe12d82d26b79780ab912ce9f', '46c70edfcec516466454ba9e6a8c9785', '3bd789acecf01e5061099643788b3714', '88d68a5e0eb181c93a3c0caa88ad1e3e', '5869485dd2c81b33d2abec7eb5aa70b6', 'f9fc263c662532c9463fb128d46ba897', 'de184995a8411e419cb7a13edc3947c4', '1ed4ab9082074e9323533172e3e2afa1', '0ab8c0a838a04b2de3c6e78ee586c532', '4e236048ca5d250adfeba5e2138ea192', '42759990c5b59cdc1df3a8b92f0d7514', '1c13fa084369fe20f41789d98e74a900', 'b029d5ec2ea5c7f763f8d40b5bdc1a91', '93a26cd0f53087760fabd990ffe827a7', 'ebe739affde93c1a985c92398822e34c', 'b364bd9af1082deac40eca8c41d47934', '21c1e25d7810b30f9b427331b5a9ee2e', '8429335ef1c6f5213a8cddf04831a03b', '3e2ae21eeea6f57ce01baadd9d29ec8f', 'b294e9d6c8829b6f2e56b148571bc760', '1271d28987ba143a3414f21c750f6763', '022fb08a02a3f77f53a0eaf4a497598a', '9c195d219519af486a6601986ed6317b', '8b70e49ba5aa7d3d78b3e570346248ad', '180552f23abe8ce9ec6acb78b4a828e5', 'e26d0837b5361149e78c39b298e78388', 'b3d974d42955cab46532f4e9cddb08b0', 'b47d085f0912569c8b4592239f896921', '25c07744a19891c63b5262ccd1475c7c', '8b073c5242e7a6c329df09edc267efb1', '7733d160e67fbe2f6c15e2a5fe5ec214', '6e5ca247727632b7ae66611f0e6d158e', 'a00c3c00b1d0c027ae7d46b86561b4c9', 'bbbc6791495fb33b74fa4086acfe1ebb', '7cd8aa3a1c0693e635727fd37d78f690', 'cd0b9c239c6c39157e237c590aa72b7a',
# 			'737380edae6d0a72102ccc00f0f36354', 'c44458d07bbae37b0cd7920089a6d43d', '21b470ca370761cac07908e8687c0a78', 'c27b512edf6116f9594f4a8168035581', '6213a1bf55e844e5271e37b45844d6aa', '29e059ecd5e49962e2bf101f09d98c10', '3a1c6a0f09a8b2886b870defaacbd86f', 'a4c648eed50f762b4a9a8b8685c5f14d', '68cd4c28336b9db9e2cdda2d84c21616', '9e2498e738251a5e903497b6c3c6cf8e', 'bfe4e68b2b293d2c3ef5de413f10244d', '828c2edf33b7d07549bc0e0a0fe06cb7', '404be823111cfba9d97269409f0ec3b6', '18ee8acad469e367bd8c6942205fc022', 'f41d52b3b4b5e416729ab3da7fefc8d4', '3cf2aecd3c15e3b71f63be735ce47313', 'b1aa9850af40b39c176cb83d8a507ac0', '64841a6f4dae252dc614c2c623788a7d', 'b75fb9d1a6e5d9113b92dca81908ad50', '0932d0fe3d115aadfa73f704b6a961b1', 'a36ac6c7a60a3eb8a6819c930c35478b', '55eeb665fe706b619e581b489886fe5e', 'a08d53ad7f719567569d67617c5a0c1b', '3ae75d1e6d68983db1fbdb2475e26525', '58bd7cae2438f9b8abb6561397e7ac3d', '363f8fa4e5b064cc1e75bab640a83f80', '10f0a247125d94a6f5fe79eaf912fc4e', '0592671f25bde093f6f3c1ec73d31fdd', '578e1737ca6ce470d884b4ce4871fa8b', 'd6ee57ccec09d27837898cfee3de1dae', 'b957c7a45e25e80733c4f7c525574926', '6cd1acb9099194d976edfe4f9f1b039b', 'b76c67ac046b40f95f759a3412e9fbe7', 'e76a7961d7d420ca20927e58be25c47e',
# 			'f68413bb2c79ae944dbd8f692f62524a', '36f219244680b8a40ba5bb1dc03d1dd5', '5a934c8a902247197855022ba9a174a4', 'f62bf0e8af7385fb942a4f19959021aa', '44eeb2a946fb2cbe10ac8dd3818b15f3', 'b26c93253f62291e1549e211cdf05c4c', '01cf658016d764ea7d0c1da9605afd3c', 'd69c201634e11e0be44cafa4aa9e008d', '6001a7c452db1e43ce22b117c01a656d', '485f491e1a7f62be6c9bad02303c9118', '14ee6a37674d9cd87181ceb06402e766', 'fc6671f67f004d9aac442c9f7655df82', 'a7b29929a29be70cb10d9f5618bd3039', 'b844bfa683e470485b87fc403f6db162', '2f3ed7a7725ece4938952bca8dc91cfe', 'bd11d1bf8c9a3923333bc4caa5bf0020', 'f3d177222f4dc54fda6669971b8c24fb', '537b606101a494239b83d89f90817f7b', '82b9669f2ae81e9e5d8e8a660bf2e17d', 'eacff4b74d036d43115190fd08479f7a', '9bbaaec933b2fbf7c377c45666995b30', '04adea534901f06adf00a0790437d956', '3b5ae26ab4abe001b5816962a5f86a52', '41e0127d57ca1632850572cdc3072cd9', '79c1c27856a99dd6ad051f26e2c03247', '21cbf9a3653728af81e0068033f9e3ea', '9e9a45f35d2215ce6e51fdd53b99d9f3', 'e8ff6067d7cd900be541311925d1864a', '1442b030e6140bc9926052baf5652c64',
# 			'9f56f5d2c17a07bd6bdde01d69f9c5a3', '8a7500851ed380ed84c47c30b1bce954', 'b9da7dcbd222feb2db9c0cd8082081b1', '4ee0af163f4aed2cb2ae29a55c6d92a4', '9fd65311516c59f984276101d0b80318', '2db63e5254393a64cbddec0a6721afee', '998d615bf378940903476e6f68396713', '26b45a99a625ebd78a24beb82142b2db', '385ed36d05740751f1823675aef792c0', '529d507db8c2dbb4291984f82c6d8f53', '00adae424f30921d656fb00d2c79e57d', '5dd41599b0f63f8168b008f1949bb7c2', '0ece68429c4c848e3d4c9182f91d350d', '842137fde29ff3edb6d7c56e784075ca', '4dfe63f003395770e45ba5d697b24e72', '9920da4501441271778e7f0b813b0d3b', '638926b26a9be4177e37441d5cb01d31', '73eaa076d37ba1fe5bd12977b26e0620', 'e3a5ed102b281b7f4aad227df97c4e15', '2246c5a41bf0dc3e3bdca820e1b4bab8', '339fc3e07b7f4286fd1a71604a67ba8a', '8160e01b1007d00ba685a78015b60864', '8969435e798e0ad917b7b6e47eb12736', 'f30960cbbd80c60e821319d89937386b', 'f73d4835844a081e21baa6f83dcf386b', '7f7f4d24815ad6d07bcd49b35748e5e3', '267c7520311b78c2d0bff744060e09a5', '7b4b75063eae5be0ab4768139df86e15', '6fc1d87839ffec25f2725c6fb80fb73e', 'acae22689b732ff61d85a3ee8d421c0b', 'f8627072c1cb04d1a783e07e334422be', '5021486f9dbc708f8c33f088f26e3758', 'c086a2cc3b8230535bf45de6be942bf4',
# 			'c558cb9d127d268e653d1d03bcbf594b', '43ae1807b8a8c75825cee7007a47862d', 'dcaeb5ad6272fa3eff85abc94413553d', '827cf4dc1047b3a1e27a0198bedd6490', '9eeee51d3c48f1acb6fcbda3a0580acb', '6327131c1f5cf17c568510ad5f6636d3', '6a3149677facaadae48d12f5d1ad3959', '439a1fe3416202cdda4ae2ad26cffb56', 'a34b48297f0ab07a1ed56b904746e430', '98516dbf9cc6e8de8dd2b9f4bbd3072c', 'c9708300f73bff52edda2b04ab8bdd9f', '3709ef1fa9c6b8d9ac5ab9cf279fc5d0', 'b82ccf2d901bcc231d6f7f17f0edf694', 'bf68eb0f8def34c9967297f0825273f7', '82d64595e1b8f1007fc01fa7a33ecd5d', 'a8c408670a8107ecef64d3b919818d04', 'f15ca882ccaa897ee92ac0c575a71061', 'ed2cedca2c9dd601b8e25f1ae21dcb91', '6d1b7f1eaedb257f9a561a8a5c4e3247', '8a61113401ac7a4b26ccef952157386c', '5acc064646f7febc5e00596c8c1b1198', 'c1c5cbdadb0d4c4b4172ed7bd5fe8673', 'a27097a860f150681d686fc7b8aeb3b4', 'aafb785305edb6bf99bba386dfb7edef', '6bfcb65bb93b7690c41bc57ae6f271c0', 'a5be722504432af437341a388a9eb060', '5181c0ddc8130bed6a8780ebe5caa6bf', 'b972003953b12e100220dbaa8c3f8129', 'ac8b2e1209f000a1aabb0919ba08ae73', '1c76c72cb836a20679b358de13569ea0', 'a591fa3b11c0ee68010dde218caf82b0', '395ebc740f1839e4e4b5f70bc540a10f'
# 		),
# 		40000,
# 		memory
# 		)) |>
#
#
#
# 		mutate(memory = if_else(
# 			.sample %in% c(
# 				'd269cc3d24192253915c76548a76f98f', 'eb3ab31045df7a1fa33cce82631f8f65', 'f3ee387727c7bdc3512f5a4dda65f42b', '20968a5c87b65b02d8bcc8cc1af2ae73', '34e775390b27327392dbd3386ef29a8d', 'b710bc9bd6a9392065ba4f0f8f1cba75', 'e679dbc708686bfbe1e09a4eee798b6d', '9aedb2e16982469a38b573e744c8a09a',
#
# 				'17ea48f5316efeeb337d58dcde24c9cf', '8d6f7f62dc6c1988dc5c73a349d6c6da', '8b70e49ba5aa7d3d78b3e570346248ad', '7733d160e67fbe2f6c15e2a5fe5ec214', '6e5ca247727632b7ae66611f0e6d158e', 'a00c3c00b1d0c027ae7d46b86561b4c9', 'bbbc6791495fb33b74fa4086acfe1ebb', '29e059ecd5e49962e2bf101f09d98c10', '68cd4c28336b9db9e2cdda2d84c21616', 'bfe4e68b2b293d2c3ef5de413f10244d', '828c2edf33b7d07549bc0e0a0fe06cb7', '404be823111cfba9d97269409f0ec3b6', '18ee8acad469e367bd8c6942205fc022', 'eacff4b74d036d43115190fd08479f7a', '9bbaaec933b2fbf7c377c45666995b30', 'e8ff6067d7cd900be541311925d1864a', '1442b030e6140bc9926052baf5652c64', 'b90cecec8b68c9a121ed0649d2448cf9'
#
# 			),
# 			160000,
# 			memory
# 		)) |>
#
# 	rowid_to_column() |>
# 	mutate(commands = pmap(list(output_file_path, input_file_path,  memory, rowid, file_id), ~
# 												 	c(
# 												 		glue("CATEGORY=light_data{..4}\nMEMORY={..3}\nCORES=1\nWALL_TIME=10000"),
# 												 		glue("{..1}:{..2} {gene_names} {files_metadata}\n{tab}Rscript light_files.R {..2} {gene_names} {files_metadata} {..5} {..1}")
# 												 	)
# 												 	))  |>
# 	pull(commands) |>
# 	unlist() |>
# 	write_lines(glue("~/PostDoc/CuratedAtlasQueryR/dev/light_files.makeflow"))



# Read arguments
args = commandArgs(trailingOnly=TRUE)
input_file = args[[1]]
gene_names = args[[2]]
files_metadata = args[[3]]
file_id = args[[4]]
output_file = args[[5]]


# Create directory
output_file |> dirname() |> dir.create( showWarnings = FALSE, recursive = TRUE)


data = loadHDF5SummarizedExperiment(input_file	)
rowData(data) = NULL
colData(data) = NULL
reducedDims(data) = NULL
data@int_colData$colPairs = data@int_colData$colPairs[,0]

# Select just the X assay
data@assays@data = data@assays@data |> as.list() %>% .[1] |> SimpleList()

gc()

rownames(data) = AnnotationDbi::mapIds(org.Hs.eg.db::org.Hs.eg.db,
 				keys = rownames(data),
 				keytype = "ENSEMBL",
 				column = "SYMBOL",
 				multiVals = "first"
							 )
data = data[!is.na(rownames(data)),]
rownames(data@assays@data$X)  = rownames(data)

# Complete gene set
missing_genes = readRDS(gene_names)  |> setdiff(rownames(data))

missing_matrix =
	HDF5RealizationSink(c(length(missing_genes),ncol(data)), as.sparse = TRUE) |>
	as("DelayedArray")

rownames(missing_matrix) = missing_genes
colnames(missing_matrix) = colnames(data)

missing_sce = SingleCellExperiment(list(X=missing_matrix),  colData=colData(data))
missing_sce@int_colData = data@int_colData
missing_sce = missing_sce[!is.na(rownames(missing_sce)),]

# Make cell name unique
data = data |> rbind(missing_sce	)

# Non redundant

# If object too big, just drop duplicates because of memory issue
if(ncol(data)>200000){
	duplicates = data@assays@data$X |> rownames() |> duplicated() |> which()
	data = SingleCellExperiment(list(X = data@assays@data$X[-duplicates,]))

} else {
	data = SingleCellExperiment(list(X = rowsum(data@assays@data$X, rownames(data@assays@data$X)) ))
}

transformation =
	readRDS(files_metadata) |>
	filter(file_id == !!file_id) |>
	mutate(transformation = case_when(
		x_normalization |> str_detect("log|ln|Log") ~ "log",
		x_normalization |> str_detect("square root") ~ "square_root",
		TRUE ~ "none"
	)) |>
	pull(transformation) |>
	unique()

data@assays@data$X =
	data@assays@data$X |>
	when(
		transformation=="log" ~ {
			.x = expm1(.)
			#type(.x) = "integer"
			.x
		},
		transformation=="square_root" ~ {
			.x = (.)^2
			#type(.x) = "integer"
			.x
		},
		~ {
			.x = (.)
			#type(.x) = "integer"
			.x
		}
	)

# If I have negative values
if((data@assays@data$X[,1:min(10000, ncol(data@assays@data$X))] |> min()) < 0)
	data@assays@data$X[data@assays@data$X<0] <- 0

# Select just the X assay
sce = SingleCellExperiment(list(X = data@assays@data$X))
rownames(sce) = rownames(data)
colnames(sce) = colnames(data)

rm(data)
gc()

sce |>	saveHDF5SummarizedExperiment(output_file, replace=TRUE)


