% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplotAlleleFreqs.R
\name{barplotAlleleFreqs}
\alias{barplotAlleleFreqs}
\alias{barplotAlleleFreqs,CrisprSet-method}
\alias{barplotAlleleFreqs,matrix-method}
\title{Plots barplots of the spectrum of variants for a sample set}
\usage{
barplotAlleleFreqs(obj, ...)

\S4method{barplotAlleleFreqs}{CrisprSet}(
  obj,
  ...,
  txdb,
  min.freq = 0,
  include.chimeras = TRUE,
  group = NULL,
  palette = c("rainbow", "bluered")
)

\S4method{barplotAlleleFreqs}{matrix}(
  obj,
  category.labels = NULL,
  group = NULL,
  bar.colours = NULL,
  group.colours = NULL,
  legend.text.size = 10,
  axis.text.size = 10,
  legend.symbol.size = 1,
  snv.label = "SNV",
  novar.label = "no variant",
  chimera.label = "Other",
  include.table = TRUE,
  classify = TRUE
)
}
\arguments{
\item{obj}{The object to be plotted}

\item{...}{additional arguments}

\item{txdb}{A transcript database object}

\item{min.freq}{Include variants with at frequency least min.freq in at least
one sample.  (Default: 0, i.e. no cutoff)}

\item{include.chimeras}{Should chimeric reads be included in results?
(Default: TRUE)}

\item{group}{A grouping factor for the columns in obj.  Columns in the
same group will be displayed in the same text colour (Default: NULL)}

\item{palette}{Colour palette.  Options are "rainbow", a quantitative palette
(default) or "bluered", a gradient palette.}

\item{category.labels}{Labels for each category, corresponding to the
rows of obj.  Only applicable when categories are provided, i.e.
"classify" is FALSE.  (Default: NULL)}

\item{bar.colours}{Colours for the categories in the barplot.
Colours must be provided if there are more than 6 different categories.}

\item{group.colours}{Colours for the text labels for the experimental groups
A set of 15 different colours is provided.}

\item{legend.text.size}{The size of the legend text, in points.}

\item{axis.text.size}{The size of the axis text, in points}

\item{legend.symbol.size}{The size of the symbols in the legend}

\item{snv.label}{The row label for single nucleotide variants}

\item{novar.label}{The row label for non-variant sequences}

\item{chimera.label}{The row label for chimeric (non-linearly aligned)
variant alleles}

\item{include.table}{Should a table of allele (variant combination)
counts and total sequences be plotted? (Default: TRUE)}

\item{classify}{If TRUE, performs a naive classification by size 
(Default:TRUE)}
}
\value{
A ggplot2 barplot of the allele distribution and optionally a table
of allele counts
}
\description{
For signature "matrix", this function optionally does a very
naive classification of variants by size.  Frameshift variant combinations are
those whose sum is not divisible by three.  Intron boundaries are *NOT* considered,
use with caution!
For signature "CrisprSet", the function uses the VariantAnnotation package to
localize variant alleles with respect to annotated transcripts.  Variants are 
annotated as "coding" when they are coding in any transcript.

(signature("CrisprSet")) Groups variants by size and type
and produces a barplot showing the variant spectrum for each sample.
Accepts all arguments accepted by barplotAlleleFreqs for signature("matrix").
Requires package "VariantAnnotation"

signature("matrix") Accepts a matrix of allele counts,
with rownames being alleles and column names samples.
}
\examples{
data("gol_clutch1")
barplotAlleleFreqs(variantCounts(gol))

# Just show the barplot without the counts table:
barplotAlleleFreqs(variantCounts(gol), include.table = FALSE)
}
\author{
Helen Lindsay
}
