\name{draw.profile}
\alias{draw.profile}
\alias{draw.profile,matrix-method}
\alias{draw.profile,list-method}
\title{Draw a coverage profile}
\description{This method draws a coverage profile for the coverage matrix that is passed as an argument to the method}
\usage{
\S4method{draw.profile}{matrix}(data,outfile=NULL,...)
\S4method{draw.profile}{list}(data,outfile=NULL,...)
}
\arguments{
 \item{data}{Matrix or list of matrices generated by the function \code{cov.matrix}}
  \item{outfile}{URL of the \code{.png} file where the plot will be created}
  \item{\dots}{Additional parameters}
}
\details{
Function to generate a plot in the \code{.png} format displaying the profile resulting from calculating the average of each row in the matrix generated by using the \code{cov.matrix} function. See the \code{\link{cov.matrix}} documentation for more details on the matrix used to draw the profile
}
\author{
  Ernesto Lowy <ernestolowy@gmail.com>
}
\seealso{
  \code{\link{cov.matrix}}
}

\examples{

  ## draw the coverage profile for a coverate matrix that was previously calculated 
  # using the cov.matrix function for a BAM file containing ChIP-seq data 
  # from a H3K36me3 histone modification experiment
  data(DF_H3K36me3)
  draw.profile(DF_H3K36me3,ylab="coverage",outfile="testProfile.png",main="testProfile",col="red")
  
  ## Now, draw two profiles for 2 different coverage matrices previously 
  # obtained for the same H3K36me3 histone modification experiment and its
  # respective 'control' file
  data(DF_H3K36me3_control)
  
  #create a list with the two matrices
  input_l=list(DF_H3K36me3,DF_H3K36me3_control)
  draw.profile(input_l,ylab="coverage",outfile="testProfile.png",main="testProfile")
}
