% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VizMethods.R
\name{VlnPlot}
\alias{VlnPlot}
\alias{VlnPlot.SingleCellExperiment}
\alias{VlnPlot,SingleCellExperiment-method}
\title{Visualization of feature expression using violin plots}
\usage{
VlnPlot.SingleCellExperiment(
  object,
  clustering.label,
  features,
  return.plot,
  rotate.x.axis.labels
)

\S4method{VlnPlot}{SingleCellExperiment}(
  object,
  clustering.label,
  features,
  return.plot = FALSE,
  rotate.x.axis.labels = FALSE
)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{clustering.label}{A variable name (of class \code{character}) available
in the cell metadata \code{colData(object)} with the clustering labels
(\code{character} or \code{factor}) to use.}

\item{features}{Feature names to plot by cluster (\code{character}) matching
\code{row.names(object)}.}

\item{return.plot}{return.plot whether to return the \code{ggplot2} object.
Default is \code{FALSE}.}

\item{rotate.x.axis.labels}{a logical denoting whether the x-axis labels should
be rotated 90 degrees or just draw it. Default is \code{FALSE}.}
}
\value{
A \code{ggplot2} object if \code{return.plot=TRUE}.
}
\description{
The \code{VlnPlot} function enables visualizing expression levels
of feature(s), across clusters using violin plots.
}
\examples{
# Import package
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Create toy SCE data
batches <- c("b1", "b2")
set.seed(239)
batch <- sample(x = batches, size = nrow(iris), replace = TRUE)
sce <- SingleCellExperiment(
    assays = list(logcounts = t(iris[, 1:4])),
    colData = DataFrame(
        "Species" = iris$Species,
        "Batch" = batch
    )
)
colnames(sce) <- paste0("samp", 1:ncol(sce))

# Plot features by clustering/grouping variable
VlnPlot(sce,
    clustering.label = "Species",
    features = row.names(sce)[1:4],
    rotate.x.axis.labels = TRUE
)

}
\keyword{plot}
\keyword{violin}
