% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{SamplePCACells}
\alias{SamplePCACells}
\title{Sample cells based on principal components distribution}
\usage{
SamplePCACells(
  data,
  batch = NULL,
  q.split = 0.5,
  p = 30,
  use.pc = "PC1",
  center = TRUE,
  scale. = TRUE
)
}
\arguments{
\item{data}{Data to compute PCA and sample cells from. Rows and columns
should represent cells and features, respectively.}

\item{batch}{Batch cell label identity (character) matching cells giving in
\code{data}. Use \code{NULL} in the absence of batches. If the batch is given
the cells are sampled in a batch wise manner, otherwise the cells are sampled
without any grouping factor. By default is \code{NULL}.}

\item{q.split}{Split (cell) batch principal component distribution by this
quantile (numeric). By default \code{0.5}, i.e., median.}

\item{p}{Number of principal components to compute (integer). By default
\code{30}.}

\item{use.pc}{Which principal component should be used for sampling cells per
batch. By default \code{"PC1"}, i.e., first principal component is used.}

\item{center}{Should the features given in \code{data} centered before
performing the PCA (logical). By default \code{TRUE}.}

\item{scale.}{Should the features given in \code{data} scaled before
performing the PCA (logical). By default \code{TRUE}.}
}
\value{
A factor with cell cluster identities (two clusters).
}
\description{
Samples cells based on their distributions along one principal component
}
\keyword{internal}
