% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{MajorityVotingFeatures}
\alias{MajorityVotingFeatures}
\alias{MajorityVotingFeatures.SingleCellExperiment}
\alias{MajorityVotingFeatures,SingleCellExperiment-method}
\title{Majority voting features by label}
\usage{
MajorityVotingFeatures.SingleCellExperiment(object, label)

\S4method{MajorityVotingFeatures}{SingleCellExperiment}(object, label)
}
\arguments{
\item{object}{An object of \code{SingleCellExperiment} class with ICP cell
cluster probability tables saved in \code{metadata(object)$coralysis$joint.probability}.
After running \code{RunParallelDivisiveICP}.}

\item{label}{Label of interest available in \code{colData(object)}.}
}
\value{
A list of with a list of data frames with feature weights per label and a data frame with a summary by label.
}
\description{
Get ICP feature coefficients for a label of interest by majority voting label across ICP clusters.
}
\examples{
\dontrun{
# Import package
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Import data from Zenodo
data.url <- "https://zenodo.org/records/14845751/files/pbmc_10Xassays.rds?download=1"
sce <- readRDS(file = url(data.url))

# Multi-level integration (just for highlighting purposes; use default parameters)
set.seed(123)
sce <- RunParallelDivisiveICP(
    object = sce, batch.label = "batch",
    k = 4, L = 10, C = 1, d = 0.5,
    train.with.bnn = FALSE, use.cluster.seed = FALSE,
    build.train.set = FALSE, ari.cutoff = 0.1,
    threads = 2
)

# Get coefficients by majority voting for a given categorical variable
coeff <- MajorityVotingFeatures(object = sce, label = "cell_type")
gene_coeff$summary
order.rows <- order(coeff$feature_coeff$Monocyte$coeff_clt2,
    decreasing = TRUE
)
head(coeff$feature_coeff$Monocyte[order.rows, ], n = 10)
}

}
\keyword{Majority}
\keyword{coefficients}
\keyword{feature}
\keyword{voting}
\keyword{weights}
