% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntegrationMethods.R
\name{AggregateDataByBatch}
\alias{AggregateDataByBatch}
\alias{AggregateDataByBatch.SingleCellExperiment}
\alias{AggregateDataByBatch,SingleCellExperiment-method}
\title{Aggregates feature expression by cell clusters, per batch if provided.}
\usage{
AggregateDataByBatch.SingleCellExperiment(object, batch.label, nhvg, p, ...)

\S4method{AggregateDataByBatch}{SingleCellExperiment}(object, batch.label, nhvg = 2000L, p = 30L, ...)
}
\arguments{
\item{object}{An object of \code{SingleCellExperiment} class.}

\item{batch.label}{Cluster identities vector corresponding to the cells in
\code{mtx}.}

\item{nhvg}{Integer of the number of highly variable features to select. By default
\code{2000}.}

\item{p}{Integer. By default \code{30}.}

\item{...}{Parameters to be passed to \code{ClusterCells()} function.}
}
\value{
A SingleCellExperiment object with feature expression aggregated by clusters.
}
\description{
The function aggregates feature expression by cell clusters, per
batch if provided.
}
\examples{
# Import package
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Import data from Zenodo
data.url <- "https://zenodo.org/records/14871436/files/pbmc_10Xassays.rds?download=1"
sce <- readRDS(file = url(data.url))

# Run with a batch
set.seed(1204)
sce <- AggregateDataByBatch(object = sce, batch.label = "batch")
logcounts(sce)[1:10, 1:10]
head(metadata(sce)$clusters)

# Run without a batch
set.seed(1204)
sce <- AggregateDataByBatch(object = sce, batch.label = NULL)
logcounts(sce)[1:10, 1:10]
head(metadata(sce)$clusters)

}
\keyword{aggregated}
\keyword{batches}
\keyword{expression}
\keyword{feature}
