% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{transformChr}
\alias{transformChr}
\title{transformChr}
\usage{
transformChr(chr, chr.transformation = "23:X,24:Y,25:MT")
}
\arguments{
\item{chr}{(character) The chromosome names to transform}

\item{chr.transformation}{(character) The transformation of the chromosomes
names in a comma separated "key:value" format.(defaults to "23:X,24:Y,25:MT")}
}
\value{
A character vector where the name of the chromosomes have been changed
according to chr.transformation parameter.
}
\description{
Transformation of the chromosomes
}
\details{
This function will transform the name of the chormosomes, according to the
parameter chr.transformation. This is useful in situations were files,
such as .seg files as the ones generated by CNVkit, have the chromosome names
as numbers. In order to transform the sexual and mitocondrial chromosomes
from numbers back to characters, we can use this function.
The exact transformation might be provided as described at
https://cnvkit.readthedocs.io/en/stable/importexport.html#import-seg,
(e.g. "key:value")
}
\examples{
seg.file <- system.file("extdata", "DNACopy_output.seg", package = "CopyNumberPlots", mustWork = TRUE)
seg.data <- read.table(file = seg.file, sep = "\t", skip = 1, stringsAsFactors = FALSE)
colnames(seg.data) <-  c("ID", "chrom", "loc.start", "loc.end", "num.mark", "seg.mean")

# here we have the name of the chromosomes in a number format and how many segments are in each one.
table(seg.data$chrom)

# by this way we have the name 23 and 24 respectively transformed to X and Y.
seg.data$chrom <- transformChr(chr = seg.data$chrom, chr.transformation ="23:X,24:Y,25:MT")
table(seg.data$chrom)

}
