% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCopyNumberCallsCnmops.R
\name{loadCopyNumberCallsCnmops}
\alias{loadCopyNumberCallsCnmops}
\title{loadCopyNumberCallsCnmops}
\usage{
loadCopyNumberCallsCnmops(cn.mops.res, chr.col = NULL, start.col = NULL, end.col = NULL, cn.col = "CN", segment.value.col = "median", genome = NULL, verbose = TRUE)
}
\arguments{
\item{cn.mops.res}{The name of the file with the data or the name of the variable with the data}

\item{chr.col}{(number or character) The name or number of the column with chromosome information. If NULL, it is automatically identified. (defaults to NULL)}

\item{start.col}{(number or character) The name or number of the column with start position information. If NULL, it is automatically identified. (defaults to NULL)}

\item{end.col}{(number or character) The name or number of the column with end position information. If NULL, it is automatically identified. (defaults to NULL)}

\item{cn.col}{(number or character) The name or number of the column with CN information. If NULL, it is automatically identified. (defaults to "CN")}

\item{segment.value.col}{(number or character) The name or number of the column with segment value. It can be mean or median. If NULL, it is automatically identified. (defaults to "median")}

\item{genome}{(character) The name of the genome (defaults to NULL)}

\item{verbose}{(logical) Whether to show information messages. (defaults to TRUE)}
}
\value{
A GRanges with a range per copy number segment or a list of GRanges with a GRanges per sample.
}
\description{
Loads copy number calls from either cn.mops result class or in a tabular format
}
\details{
This function will load segments data from either cn.mops result class or
in a tabular format from a file. Internally it uses the \code{toGRanges} function from regioneR
package and can work with any format accepted by it, including R objects
and local or remote files. 
Column names of the format loaded are specified as default but,
if no column names are specified, it will use simple heuristics to try to
identify the relevant data columns.
}
\examples{
# loadCopyNumberCallsCnmops from cn.mops result class:
#NOT RUN - Example loading data from a results object created by cn.mops
# require(cn.mops)
# data(cn.mops, package = "cn.mops")

# cn.mops.res <- cn.mops(XRanges)
# cn.mops.res <- calcIntegerCopyNumbers(cn.mops.res)
# cnv.call <- loadCopyNumberCallsCnmops(cn.mops.res = cn.mops.res)  

# loadCopyNumberCallsCnmops from a file where cn.mops result was saved:
cn.mops.res <- system.file("extdata", "cn.mops.segmentation.csv", package = "CopyNumberPlots", mustWork = TRUE)
cnv.call <- loadCopyNumberCallsCnmops(cn.mops.res = cn.mops.res) 

}
