% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colByCopyNumber.R
\name{colByCopyNumber}
\alias{colByCopyNumber}
\title{colByCopyNumber}
\usage{
colByCopyNumber(data, cn.calls, cn.column="cn", cn.colors=NULL)
}
\arguments{
\item{data}{The data elements. Can be a GRanges or anything accepted by \code{\link[regioneR]{toGRanges}}}

\item{cn.calls}{The CN calls to use to select the color for the data elements}

\item{cn.column}{The name of the column with the copy number information. (defaults to "cn")}

\item{cn.colors}{The specification of the colors. Internally, it used to call the function \link{getCopyNumberColors}. Detailed documentation on color specification can be found there. (defaults to NULL)}
}
\value{
Return a vector of colors with the same length as the number of elements in
data
}
\description{
Assign a color to each data element according to the copy number status
of the its genomic location
}
\details{
Given a set of data elements positioned on the genome (either a GRanges
or any other format accepted by regioneR's \code{\link[regioneR]{toGRanges}})
and a set of copy number calls, assign a color to each element depending on
the copy number status of the genomic region where it's located. The colors
can be customized using the \code{cn.colors} parameter as documented in
\link{getCopyNumberColors}.
}
\examples{

pos <- sort(floor(runif(1000, 1, 10000)))
baf.data <- toGRanges("chr1", pos, pos)
baf.data$baf <- rnorm(1000, mean = 0.5, sd = 0.05)
baf.data$baf[1:400] <- baf.data$baf[1:400] + c(0.2, -0.2)

breakpoint <- start(baf.data)[400]
cn.calls <- toGRanges(data.frame(chr=c("chr1", "chr1"), start=c(1, breakpoint+1), end=c(breakpoint, 10000), cn=c(3,2)))

kp <- plotKaryotype(zoom=toGRanges("chr1", 1, 10000))
plotBAF(kp, baf.data, points.col = colByCopyNumber(baf.data, cn.calls))


}
\seealso{
\link[regioneR]{toGRanges}, \link{getCopyNumberColors}, \link{plotBAF}
}
