[![Project Status: Active – The project has reached a stable, usable state and is being actively developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![R-CMD-check-bioc](https://github.com/RforMassSpectrometry/CompoundDb/workflows/R-CMD-check-bioc/badge.svg)](https://github.com/RforMassSpectrometry/CompoundDb/actions?query=workflow%3AR-CMD-check-bioc)
[![codecov](https://codecov.io/gh/rformassspectrometry/CompoundDb/branch/main/graph/badge.svg?token=7g2DAgHR71)](https://codecov.io/gh/rformassspectrometry/CompoundDb)
[![license](https://img.shields.io/badge/license-Artistic--2.0-brightgreen.svg)](https://opensource.org/licenses/Artistic-2.0)
[![years in bioc](http://bioconductor.org/shields/years-in-bioc/CompoundDb.svg)](https://bioconductor.org/packages/release/bioc/html/CompoundDb.html)
[![Ranking by downloads](http://bioconductor.org/shields/downloads/release/CompoundDb.svg)](https://bioconductor.org/packages/stats/bioc/CompoundDb/)
[![build release](http://bioconductor.org/shields/build/release/bioc/CompoundDb.svg)](https://bioconductor.org/checkResults/release/bioc-LATEST/CompoundDb/)
[![build devel](http://bioconductor.org/shields/build/devel/bioc/CompoundDb.svg)](https://bioconductor.org/checkResults/devel/bioc-LATEST/CompoundDb/)

`CompoundDb` ... preserve compound annotations.

# Installation and requirements

The package can be installed with

```r
install.packages(c("BiocManager", "remotes"))
BiocManager::install("CompoundDb")
```

# Creating and using (chemical) compound databases

This package provides functionality to create and use compound databases
generated from (mostly publicly) available resources such as
[HMDB](http://www.hmdb.ca), [ChEBI](https://www.ebi.ac.uk/chebi/) and
[PubChem](https://pubchem.ncbi.nlm.nih.gov).


For more information see the package
[homepage](https://rformassspectrometry.github.io/CompoundDb).


# Contributions

Contributions are highly welcome and should follow the [contribution
guidelines](https://rformassspectrometry.github.io/RforMassSpectrometry/articles/RforMassSpectrometry.html#contributions).
Also, please check the coding style guidelines in the [RforMassSpectrometry
vignette](https://rformassspectrometry.github.io/RforMassSpectrometry/articles/RforMassSpectrometry.html).
