<!-- Generated by pkgdown: do not edit by hand -->
<!DOCTYPE html>
<html lang="en">
  <head>
  <meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Restore the index vector to index matrix in layer_fun — restore_matrix • ComplexHeatmap</title>

<!-- jquery -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<!-- Bootstrap -->

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha256-916EbMg70RQy9LHiGkXzG8hSg9EdNy97GazNG/aiY1w=" crossorigin="anonymous" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha256-U5ZEeKfGNOja007MMD3YBI0A3OSZOQbeG6z2f2Y0hu8=" crossorigin="anonymous"></script>

<!-- Font Awesome icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/all.min.css" integrity="sha256-nAmazAk6vS34Xqo0BSrTb+abbtFlgsFK7NKSi6o7Y78=" crossorigin="anonymous" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/v4-shims.min.css" integrity="sha256-6qHlizsOWFskGlwVOKuns+D1nB6ssZrHQrNj1wGplHc=" crossorigin="anonymous" />

<!-- clipboard.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.4/clipboard.min.js" integrity="sha256-FiZwavyI2V6+EXO1U+xzLG3IKldpiTFf3153ea9zikQ=" crossorigin="anonymous"></script>

<!-- headroom.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/headroom.min.js" integrity="sha256-DJFC1kqIhelURkuza0AvYal5RxMtpzLjFhsnVIeuk+U=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/jQuery.headroom.min.js" integrity="sha256-ZX/yNShbjqsohH1k95liqY9Gd8uOiE1S4vZc+9KQ1K4=" crossorigin="anonymous"></script>

<!-- pkgdown -->
<link href="../pkgdown.css" rel="stylesheet">
<script src="../pkgdown.js"></script>



<meta property="og:title" content="Restore the index vector to index matrix in layer_fun — restore_matrix" />

<meta property="og:description" content="Restore the index vector to index matrix in layer_fun" />
<meta name="twitter:card" content="summary" />



<!-- mathjax -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/MathJax.js" integrity="sha256-nvJJv9wWKEm88qvoQl9ekL2J+k/RWIsaSScxxlsrv8k=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/config/TeX-AMS-MML_HTMLorMML.js" integrity="sha256-84DKXVJXs0/F8OTMzX4UR909+jtl4G7SPypPavF+GfA=" crossorigin="anonymous"></script>

<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->



  </head>

  <body>
    <div class="container template-reference-topic">
      <header>
      <div class="navbar navbar-default navbar-fixed-top" role="navigation">
  <div class="container">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <span class="navbar-brand">
        <a class="navbar-link" href="../index.html">ComplexHeatmap</a>
        <span class="version label label-default" data-toggle="tooltip" data-placement="bottom" title="Released version">2.1.0</span>
      </span>
    </div>

    <div id="navbar" class="navbar-collapse collapse">
      <ul class="nav navbar-nav">
        <li>
  <a href="../index.html">
    <span class="fas fa fas fa-home fa-lg"></span>
     
  </a>
</li>
<li>
  <a href="../reference/index.html">Reference</a>
</li>
<li class="dropdown">
  <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
    Articles
     
    <span class="caret"></span>
  </a>
  <ul class="dropdown-menu" role="menu">
    <li>
      <a href="../articles/complex_heatmap.html">UNKNOWN TITLE</a>
    </li>
    <li>
      <a href="../articles/most_probably_asked_questions.html">UNKNOWN TITLE</a>
    </li>
  </ul>
</li>
      </ul>
      
      <ul class="nav navbar-nav navbar-right">
        <li>
  <a href="https://github.com/jokergoo/ComplexHeatmap">
    <span class="fab fa fab fa-github fa-lg"></span>
     
  </a>
</li>
      </ul>
      
    </div><!--/.nav-collapse -->
  </div><!--/.container -->
</div><!--/.navbar -->

      

      </header>

<div class="row">
  <div class="col-md-9 contents">
    <div class="page-header">
    <h1>Restore the index vector to index matrix in layer_fun</h1>
    
    <div class="hidden name"><code>restore_matrix.rd</code></div>
    </div>

    <div class="ref-description">
    
    <p>Restore the index vector to index matrix in layer_fun</p>
    
    </div>

    <pre class="usage"><span class='fu'><a href='restore_matrix.rd.html'>restore_matrix</a></span>(<span class='no'>j</span>, <span class='no'>i</span>, <span class='no'>x</span>, <span class='no'>y</span>)</pre>
    
    <h2 class="hasAnchor" id="arguments"><a class="anchor" href="#arguments"></a>Arguments</h2>
    <table class="ref-arguments">
    <colgroup><col class="name" /><col class="desc" /></colgroup>
    <tr>
      <th>j</th>
      <td><p>Column indices directly from <code>layer_fun</code>.</p></td>
    </tr>
    <tr>
      <th>i</th>
      <td><p>Row indices directly from <code>layer_fun</code>.</p></td>
    </tr>
    <tr>
      <th>x</th>
      <td><p>Position on x-direction directly from <code>layer_fun</code>.</p></td>
    </tr>
    <tr>
      <th>y</th>
      <td><p>Position on y-direction directly from <code>layer_fun</code>.</p></td>
    </tr>
    </table>
    
    <h2 class="hasAnchor" id="details"><a class="anchor" href="#details"></a>Details</h2>

    <p>The values that are sent to <code>layer_fun</code> are all vectors (for the vectorization
of the grid graphic functions), however, the heatmap slice where
<code>layer_fun</code> is applied to, is still represented by a matrix, thus, it would be
very convinient if all the arguments in <code>layer_fun</code> can be converted to the
sub-matrix for the current slice. Here, as shown in above example,
<code><a href='restore_matrix.rd.html'>restore_matrix</a></code> does the job. <code><a href='restore_matrix.rd.html'>restore_matrix</a></code> directly accepts the first
four argument in <code>layer_fun</code> and returns an index matrix, where rows and
columns correspond to the rows and columns in the current slice, from top to
bottom and from left to right. The values in the matrix are the natural order
of e.g. vector <code>j</code> in current slice.</p>
<p>For following code:</p>
<p></p><pre>
    Heatmap(small_mat, name = "mat", col = col_fun,
        row_km = 2, column_km = 2,
        layer_fun = function(j, i, x, y, w, h, fill) {
            ind_mat = restore_matrix(j, i, x, y)
            print(ind_mat)
        }
    )  </pre>

<p>The first output which is for the top-left slice:</p>
<p></p><pre>
         [,1] [,2] [,3] [,4] [,5]
    [1,]    1    4    7   10   13
    [2,]    2    5    8   11   14
    [3,]    3    6    9   12   15  </pre>

<p>As you see, this is a three-row and five-column index matrix where the first
row corresponds to the top row in the slice. The values in the matrix
correspond to the natural index (i.e. 1, 2, ...) in <code>j</code>, <code>i</code>, <code>x</code>, <code>y</code>,
... in <code>layer_fun</code>. Now, if we want to add values on the second column in the
top-left slice, the code which is put inside <code>layer_fun</code> would look like:</p>
<p></p><pre>
    for(ind in ind_mat[, 2]) {
        grid.text(small_mat[i[ind], j[ind]], x[ind], y[ind], ...)
    }  </pre>

    

    <h2 class="hasAnchor" id="examples"><a class="anchor" href="#examples"></a>Examples</h2>
    <pre class="examples"><div class='input'><span class='fu'><a href='https://rdrr.io/r/base/Random.html'>set.seed</a></span>(<span class='fl'>123</span>)
<span class='no'>mat</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/matrix.html'>matrix</a></span>(<span class='fu'><a href='https://rdrr.io/r/stats/Normal.html'>rnorm</a></span>(<span class='fl'>81</span>), <span class='kw'>nr</span> <span class='kw'>=</span> <span class='fl'>9</span>)
<span class='fu'><a href='Heatmap.rd.html'>Heatmap</a></span>(<span class='no'>mat</span>, <span class='kw'>row_km</span> <span class='kw'>=</span> <span class='fl'>2</span>, <span class='kw'>column_km</span> <span class='kw'>=</span> <span class='fl'>2</span>,
    <span class='kw'>layer_fun</span> <span class='kw'>=</span> <span class='kw'>function</span>(<span class='no'>j</span>, <span class='no'>i</span>, <span class='no'>x</span>, <span class='no'>y</span>, <span class='no'>width</span>, <span class='no'>height</span>, <span class='no'>fill</span>) {
       <span class='no'>ind_mat</span> <span class='kw'>=</span> <span class='fu'><a href='restore_matrix.rd.html'>restore_matrix</a></span>(<span class='no'>j</span>, <span class='no'>i</span>, <span class='no'>x</span>, <span class='no'>y</span>)
       <span class='fu'><a href='https://rdrr.io/r/base/print.html'>print</a></span>(<span class='no'>ind_mat</span>)
})</div><div class='img'><img src='restore_matrix-1.png' alt='' width='700' height='433' /></div><div class='output co'>#&gt;      [,1] [,2] [,3] [,4] [,5]
#&gt; [1,]    1    4    7   10   13
#&gt; [2,]    2    5    8   11   14
#&gt; [3,]    3    6    9   12   15
#&gt;      [,1] [,2] [,3] [,4]
#&gt; [1,]    1    4    7   10
#&gt; [2,]    2    5    8   11
#&gt; [3,]    3    6    9   12
#&gt;      [,1] [,2] [,3] [,4] [,5]
#&gt; [1,]    1    7   13   19   25
#&gt; [2,]    2    8   14   20   26
#&gt; [3,]    3    9   15   21   27
#&gt; [4,]    4   10   16   22   28
#&gt; [5,]    5   11   17   23   29
#&gt; [6,]    6   12   18   24   30
#&gt;      [,1] [,2] [,3] [,4]
#&gt; [1,]    1    7   13   19
#&gt; [2,]    2    8   14   20
#&gt; [3,]    3    9   15   21
#&gt; [4,]    4   10   16   22
#&gt; [5,]    5   11   17   23
#&gt; [6,]    6   12   18   24</div><div class='input'>
<span class='fu'><a href='https://rdrr.io/r/base/Random.html'>set.seed</a></span>(<span class='fl'>123</span>)
<span class='no'>mat</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/matrix.html'>matrix</a></span>(<span class='fu'><a href='https://rdrr.io/r/base/Round.html'>round</a></span>(<span class='fu'><a href='https://rdrr.io/r/stats/Normal.html'>rnorm</a></span>(<span class='fl'>81</span>), <span class='fl'>2</span>), <span class='kw'>nr</span> <span class='kw'>=</span> <span class='fl'>9</span>)
<span class='fu'><a href='Heatmap.rd.html'>Heatmap</a></span>(<span class='no'>mat</span>, <span class='kw'>row_km</span> <span class='kw'>=</span> <span class='fl'>2</span>, <span class='kw'>column_km</span> <span class='kw'>=</span> <span class='fl'>2</span>,
    <span class='kw'>layer_fun</span> <span class='kw'>=</span> <span class='kw'>function</span>(<span class='no'>j</span>, <span class='no'>i</span>, <span class='no'>x</span>, <span class='no'>y</span>, <span class='no'>width</span>, <span class='no'>height</span>, <span class='no'>fill</span>) {
       <span class='no'>ind_mat</span> <span class='kw'>=</span> <span class='fu'><a href='restore_matrix.rd.html'>restore_matrix</a></span>(<span class='no'>j</span>, <span class='no'>i</span>, <span class='no'>x</span>, <span class='no'>y</span>)
       <span class='no'>ind</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/unique.html'>unique</a></span>(<span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='no'>ind_mat</span>[<span class='fl'>2</span>, ], <span class='no'>ind_mat</span>[, <span class='fl'>3</span>]))
       <span class='fu'>grid.text</span>(<span class='fu'><a href='pindex.rd.html'>pindex</a></span>(<span class='no'>mat</span>, <span class='no'>i</span>[<span class='no'>ind</span>], <span class='no'>j</span>[<span class='no'>ind</span>]), <span class='no'>x</span>[<span class='no'>ind</span>], <span class='no'>y</span>[<span class='no'>ind</span>])
})</div><div class='img'><img src='restore_matrix-2.png' alt='' width='700' height='433' /></div></pre>
  </div>
  <div class="col-md-3 hidden-xs hidden-sm" id="sidebar">
    <h2>Contents</h2>
    <ul class="nav nav-pills nav-stacked">
      <li><a href="#arguments">Arguments</a></li>
      
      <li><a href="#details">Details</a></li>
      
      <li><a href="#examples">Examples</a></li>
    </ul>

  </div>
</div>


      <footer>
      <div class="copyright">
  <p>Developed by Zuguang Gu.</p>
</div>

<div class="pkgdown">
  <p>Site built with <a href="https://pkgdown.r-lib.org/">pkgdown</a> 1.4.1.</p>
</div>

      </footer>
   </div>

  


  </body>
</html>


