<!-- Generated by pkgdown: do not edit by hand -->
<!DOCTYPE html>
<html lang="en">
  <head>
  <meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Make a Combination Matrix for UpSet Plot — make_comb_mat • ComplexHeatmap</title>

<!-- jquery -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<!-- Bootstrap -->

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha256-916EbMg70RQy9LHiGkXzG8hSg9EdNy97GazNG/aiY1w=" crossorigin="anonymous" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha256-U5ZEeKfGNOja007MMD3YBI0A3OSZOQbeG6z2f2Y0hu8=" crossorigin="anonymous"></script>

<!-- Font Awesome icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/all.min.css" integrity="sha256-nAmazAk6vS34Xqo0BSrTb+abbtFlgsFK7NKSi6o7Y78=" crossorigin="anonymous" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/v4-shims.min.css" integrity="sha256-6qHlizsOWFskGlwVOKuns+D1nB6ssZrHQrNj1wGplHc=" crossorigin="anonymous" />

<!-- clipboard.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.4/clipboard.min.js" integrity="sha256-FiZwavyI2V6+EXO1U+xzLG3IKldpiTFf3153ea9zikQ=" crossorigin="anonymous"></script>

<!-- headroom.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/headroom.min.js" integrity="sha256-DJFC1kqIhelURkuza0AvYal5RxMtpzLjFhsnVIeuk+U=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/jQuery.headroom.min.js" integrity="sha256-ZX/yNShbjqsohH1k95liqY9Gd8uOiE1S4vZc+9KQ1K4=" crossorigin="anonymous"></script>

<!-- pkgdown -->
<link href="../pkgdown.css" rel="stylesheet">
<script src="../pkgdown.js"></script>



<meta property="og:title" content="Make a Combination Matrix for UpSet Plot — make_comb_mat" />

<meta property="og:description" content="Make a Combination Matrix for UpSet Plot" />
<meta name="twitter:card" content="summary" />



<!-- mathjax -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/MathJax.js" integrity="sha256-nvJJv9wWKEm88qvoQl9ekL2J+k/RWIsaSScxxlsrv8k=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/config/TeX-AMS-MML_HTMLorMML.js" integrity="sha256-84DKXVJXs0/F8OTMzX4UR909+jtl4G7SPypPavF+GfA=" crossorigin="anonymous"></script>

<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->



  </head>

  <body>
    <div class="container template-reference-topic">
      <header>
      <div class="navbar navbar-default navbar-fixed-top" role="navigation">
  <div class="container">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <span class="navbar-brand">
        <a class="navbar-link" href="../index.html">ComplexHeatmap</a>
        <span class="version label label-default" data-toggle="tooltip" data-placement="bottom" title="Released version">2.1.0</span>
      </span>
    </div>

    <div id="navbar" class="navbar-collapse collapse">
      <ul class="nav navbar-nav">
        <li>
  <a href="../index.html">
    <span class="fas fa fas fa-home fa-lg"></span>
     
  </a>
</li>
<li>
  <a href="../reference/index.html">Reference</a>
</li>
<li class="dropdown">
  <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
    Articles
     
    <span class="caret"></span>
  </a>
  <ul class="dropdown-menu" role="menu">
    <li>
      <a href="../articles/complex_heatmap.html">UNKNOWN TITLE</a>
    </li>
    <li>
      <a href="../articles/most_probably_asked_questions.html">UNKNOWN TITLE</a>
    </li>
  </ul>
</li>
      </ul>
      
      <ul class="nav navbar-nav navbar-right">
        <li>
  <a href="https://github.com/jokergoo/ComplexHeatmap">
    <span class="fab fa fab fa-github fa-lg"></span>
     
  </a>
</li>
      </ul>
      
    </div><!--/.nav-collapse -->
  </div><!--/.container -->
</div><!--/.navbar -->

      

      </header>

<div class="row">
  <div class="col-md-9 contents">
    <div class="page-header">
    <h1>Make a Combination Matrix for UpSet Plot</h1>
    
    <div class="hidden name"><code>make_comb_mat.rd</code></div>
    </div>

    <div class="ref-description">
    
    <p>Make a Combination Matrix for UpSet Plot</p>
    
    </div>

    <pre class="usage"><span class='fu'><a href='make_comb_mat.rd.html'>make_comb_mat</a></span>(<span class='no'>...</span>, <span class='kw'>mode</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='st'>"distinct"</span>, <span class='st'>"intersect"</span>, <span class='st'>"union"</span>),
    <span class='kw'>top_n_sets</span> <span class='kw'>=</span> <span class='fl'>Inf</span>, <span class='kw'>min_set_size</span> <span class='kw'>=</span> -<span class='fl'>Inf</span>, <span class='kw'>remove_empty_comb_set</span> <span class='kw'>=</span> <span class='fl'>TRUE</span>,
    <span class='kw'>remove_complement_set</span> <span class='kw'>=</span> <span class='fl'>FALSE</span>, <span class='kw'>universal_set</span> <span class='kw'>=</span> <span class='kw'>NULL</span>,
    <span class='kw'>complement_size</span> <span class='kw'>=</span> <span class='kw'>NULL</span>, <span class='kw'>value_fun</span> <span class='kw'>=</span> <span class='kw'>NULL</span>)</pre>
    
    <h2 class="hasAnchor" id="arguments"><a class="anchor" href="#arguments"></a>Arguments</h2>
    <table class="ref-arguments">
    <colgroup><col class="name" /><col class="desc" /></colgroup>
    <tr>
      <th>...</th>
      <td><p>The input sets. If it is represented as a single variable, it should be a matrix/data frame or a list. If it is multiple variables, it should be name-value pairs, see Input section for explanation.</p></td>
    </tr>
    <tr>
      <th>mode</th>
      <td><p>The mode for forming the combination set, see Mode section.</p></td>
    </tr>
    <tr>
      <th>top_n_sets</th>
      <td><p>Number of sets with largest size.</p></td>
    </tr>
    <tr>
      <th>min_set_size</th>
      <td><p>Ths minimal set size that is used for generating the combination matrix.</p></td>
    </tr>
    <tr>
      <th>remove_empty_comb_set</th>
      <td><p>Whether remove empty combination sets?</p></td>
    </tr>
    <tr>
      <th>remove_complement_set</th>
      <td><p>Whether remove the complement set which has no intersection to any of the set.</p></td>
    </tr>
    <tr>
      <th>universal_set</th>
      <td><p>The universal set. If it is set, the size of the complement set of all sets is also calculated. It if is specified, <code>complement_size</code> is ignored.</p></td>
    </tr>
    <tr>
      <th>complement_size</th>
      <td><p>The size for the complement of all sets. If it is specified, the combination set name will be like "00...".</p></td>
    </tr>
    <tr>
      <th>value_fun</th>
      <td><p>For each combination set, how to calculate the size? If it is a scalar set,  the length of the vector is the size of the set, while if it is a region-based set, (i.e. <code>GRanges</code> or <code>IRanges</code> object), the sum of widths of regions in the set is calculated as the size of the set.</p></td>
    </tr>
    </table>
    
    <h2 class="hasAnchor" id="input"><a class="anchor" href="#input"></a>Input</h2>

    <p>To represent multiple sets, the variable can be represented as:</p>
<p>1. A list of sets where each set is a vector, e.g.:</p>
<p></p><pre>
    list(set1 = c("a", "b", "c"),
         set2 = c("b", "c", "d", "e"),
         ...)  </pre>

<p>2. A binary matrix/data frame where rows are elements and columns are sets, e.g.:</p>
<p></p><pre>
      a b c
    h 1 1 1
    t 1 0 1
    j 1 0 0
    u 1 0 1
    w 1 0 0
    ...  </pre>

<p>If the variable is a data frame, the binary columns (only contain 0 and 1) and the logical
columns are only kept.</p>
<p>The set can be genomic regions, then it can only be represented as a list of <code>GRanges</code> objects.</p>
    
    <h2 class="hasAnchor" id="mode"><a class="anchor" href="#mode"></a>Mode</h2>

    <p>E.g. for three sets (A, B, C), the UpSet approach splits the combination of selecting elements
in the set or not in the set and calculates the sizes of the combination sets. For three sets,
all possible combinations are:</p>
<p></p><pre>
    A B C
    1 1 1
    1 1 0
    1 0 1
    0 1 1
    1 0 0
    0 1 0
    0 0 1  </pre>

<p>A value of 1 means to select that set and 0 means not to select that set. E.g., "1 1 0"
means to select set A, B while not set C. Note there is no "0 0 0", because the background 
size is not of interest here. With the code of selecting and not selecting the sets, next
we need to define how to calculate the size of that combination set. There are three modes:</p>
<p>1. <code>distinct</code> mode: 1 means in that set and 0 means not in that set, then "1 1 0" means a
set of elements also in set A and B, while not in C (i.e. <code><a href='https://rdrr.io/pkg/GenomicRanges/man/setops-methods.html'>setdiff(intersect(A, B), C)</a></code>). Under
this mode, the seven combination sets are the seven partitions in the Venn diagram and they
are mutually exclusive.</p>
<p>2. <code>intersect</code> mode: 1 means in that set and 0 is not taken into account, then, "1 1 0" means
a set of elements in set A and B, and they can also in C or not in C (i.e. <code><a href='https://rdrr.io/pkg/GenomicRanges/man/setops-methods.html'>intersect(A, B)</a></code>).
Under this mode, the seven combination sets can overlap.</p>
<p>3. <code>union</code> mode: 1 means in that set and 0 is not taken into account. When there are multiple
1, the relationship is OR. Then, "1 1 0" means a set of elements in set A or B, and they can also in C or not in C (i.e. <code><a href='https://rdrr.io/pkg/GenomicRanges/man/setops-methods.html'>union(A, B)</a></code>).
Under this mode, the seven combination sets can overlap.</p>
    
    <h2 class="hasAnchor" id="value"><a class="anchor" href="#value"></a>Value</h2>

    <p>A matrix also in a class of <code>comb_mat</code>.</p>
<p>Following functions can be applied to it: <code><a href='set_name.rd.html'>set_name</a></code>, <code><a href='comb_name.rd.html'>comb_name</a></code>, <code><a href='set_size.rd.html'>set_size</a></code>, <code><a href='comb_size.rd.html'>comb_size</a></code>, <code><a href='comb_degree.rd.html'>comb_degree</a></code>,
<code><a href='extract_comb.rd.html'>extract_comb</a></code> and <code><a href='t.comb_mat.rd.html'>t.comb_mat</a></code>.</p>
    

    <h2 class="hasAnchor" id="examples"><a class="anchor" href="#examples"></a>Examples</h2>
    <pre class="examples"><div class='input'><span class='fu'><a href='https://rdrr.io/r/base/Random.html'>set.seed</a></span>(<span class='fl'>123</span>)
<span class='no'>lt</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/list.html'>list</a></span>(<span class='kw'>a</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/sample.html'>sample</a></span>(<span class='no'>letters</span>, <span class='fl'>10</span>),
          <span class='kw'>b</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/sample.html'>sample</a></span>(<span class='no'>letters</span>, <span class='fl'>15</span>),
          <span class='kw'>c</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/sample.html'>sample</a></span>(<span class='no'>letters</span>, <span class='fl'>20</span>))
<span class='no'>m</span> <span class='kw'>=</span> <span class='fu'><a href='make_comb_mat.rd.html'>make_comb_mat</a></span>(<span class='no'>lt</span>)

<span class='no'>mat</span> <span class='kw'>=</span> <span class='fu'><a href='list_to_matrix.rd.html'>list_to_matrix</a></span>(<span class='no'>lt</span>)
<span class='no'>mat</span></div><div class='output co'>#&gt;   a b c
#&gt; a 0 1 1
#&gt; b 0 0 1
#&gt; c 1 1 0
#&gt; d 0 1 0
#&gt; e 1 1 1
#&gt; f 0 0 1
#&gt; g 0 1 1
#&gt; h 0 1 1
#&gt; i 0 1 1
#&gt; j 1 1 1
#&gt; k 1 1 0
#&gt; l 0 1 1
#&gt; m 0 0 1
#&gt; n 1 1 0
#&gt; o 1 0 1
#&gt; q 0 0 1
#&gt; r 1 0 1
#&gt; s 1 1 0
#&gt; t 0 0 1
#&gt; u 0 1 1
#&gt; v 0 0 1
#&gt; w 0 0 1
#&gt; x 1 1 1
#&gt; y 1 1 1
#&gt; z 0 0 1</div><div class='input'><span class='no'>m</span> <span class='kw'>=</span> <span class='fu'><a href='make_comb_mat.rd.html'>make_comb_mat</a></span>(<span class='no'>mat</span>)

<span class='kw'>if</span> (<span class='fl'>FALSE</span>) {
<span class='fu'><a href='https://rdrr.io/r/base/library.html'>library</a></span>(<span class='no'>circlize</span>)
<span class='fu'><a href='https://rdrr.io/r/base/library.html'>library</a></span>(<span class='no'>GenomicRanges</span>)
<span class='no'>lt</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/lapply.html'>lapply</a></span>(<span class='fl'>1</span>:<span class='fl'>4</span>, <span class='kw'>function</span>(<span class='no'>i</span>) <span class='fu'><a href='https://rdrr.io/pkg/circlize/man/generateRandomBed.html'>generateRandomBed</a></span>())
<span class='no'>lt</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/lapply.html'>lapply</a></span>(<span class='no'>lt</span>, <span class='kw'>function</span>(<span class='no'>df</span>) <span class='fu'><a href='https://rdrr.io/pkg/GenomicRanges/man/GRanges-class.html'>GRanges</a></span>(<span class='kw'>seqnames</span> <span class='kw'>=</span> <span class='no'>df</span>[, <span class='fl'>1</span>],
    <span class='kw'>ranges</span> <span class='kw'>=</span> <span class='fu'>IRanges</span>(<span class='no'>df</span>[, <span class='fl'>2</span>], <span class='no'>df</span>[, <span class='fl'>3</span>])))
<span class='fu'><a href='https://rdrr.io/r/base/names.html'>names</a></span>(<span class='no'>lt</span>) <span class='kw'>=</span> <span class='no'>letters</span>[<span class='fl'>1</span>:<span class='fl'>4</span>]
<span class='no'>m</span> <span class='kw'>=</span> <span class='fu'><a href='make_comb_mat.rd.html'>make_comb_mat</a></span>(<span class='no'>lt</span>)
}</div></pre>
  </div>
  <div class="col-md-3 hidden-xs hidden-sm" id="sidebar">
    <h2>Contents</h2>
    <ul class="nav nav-pills nav-stacked">
      <li><a href="#arguments">Arguments</a></li>
      
      <li><a href="#input">Input</a></li>

      <li><a href="#mode">Mode</a></li>

      <li><a href="#value">Value</a></li>
      
      <li><a href="#examples">Examples</a></li>
    </ul>

  </div>
</div>


      <footer>
      <div class="copyright">
  <p>Developed by Zuguang Gu.</p>
</div>

<div class="pkgdown">
  <p>Site built with <a href="https://pkgdown.r-lib.org/">pkgdown</a> 1.4.1.</p>
</div>

      </footer>
   </div>

  


  </body>
</html>


