<!-- Generated by pkgdown: do not edit by hand -->
<!DOCTYPE html>
<html lang="en">
  <head>
  <meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Draw the Dendrogram — grid.dendrogram • ComplexHeatmap</title>

<!-- jquery -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<!-- Bootstrap -->

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha256-916EbMg70RQy9LHiGkXzG8hSg9EdNy97GazNG/aiY1w=" crossorigin="anonymous" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha256-U5ZEeKfGNOja007MMD3YBI0A3OSZOQbeG6z2f2Y0hu8=" crossorigin="anonymous"></script>

<!-- Font Awesome icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/all.min.css" integrity="sha256-nAmazAk6vS34Xqo0BSrTb+abbtFlgsFK7NKSi6o7Y78=" crossorigin="anonymous" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/v4-shims.min.css" integrity="sha256-6qHlizsOWFskGlwVOKuns+D1nB6ssZrHQrNj1wGplHc=" crossorigin="anonymous" />

<!-- clipboard.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.4/clipboard.min.js" integrity="sha256-FiZwavyI2V6+EXO1U+xzLG3IKldpiTFf3153ea9zikQ=" crossorigin="anonymous"></script>

<!-- headroom.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/headroom.min.js" integrity="sha256-DJFC1kqIhelURkuza0AvYal5RxMtpzLjFhsnVIeuk+U=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/jQuery.headroom.min.js" integrity="sha256-ZX/yNShbjqsohH1k95liqY9Gd8uOiE1S4vZc+9KQ1K4=" crossorigin="anonymous"></script>

<!-- pkgdown -->
<link href="../pkgdown.css" rel="stylesheet">
<script src="../pkgdown.js"></script>



<meta property="og:title" content="Draw the Dendrogram — grid.dendrogram" />

<meta property="og:description" content="Draw the Dendrogram" />
<meta name="twitter:card" content="summary" />



<!-- mathjax -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/MathJax.js" integrity="sha256-nvJJv9wWKEm88qvoQl9ekL2J+k/RWIsaSScxxlsrv8k=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/config/TeX-AMS-MML_HTMLorMML.js" integrity="sha256-84DKXVJXs0/F8OTMzX4UR909+jtl4G7SPypPavF+GfA=" crossorigin="anonymous"></script>

<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->



  </head>

  <body>
    <div class="container template-reference-topic">
      <header>
      <div class="navbar navbar-default navbar-fixed-top" role="navigation">
  <div class="container">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <span class="navbar-brand">
        <a class="navbar-link" href="../index.html">ComplexHeatmap</a>
        <span class="version label label-default" data-toggle="tooltip" data-placement="bottom" title="Released version">2.1.0</span>
      </span>
    </div>

    <div id="navbar" class="navbar-collapse collapse">
      <ul class="nav navbar-nav">
        <li>
  <a href="../index.html">
    <span class="fas fa fas fa-home fa-lg"></span>
     
  </a>
</li>
<li>
  <a href="../reference/index.html">Reference</a>
</li>
<li class="dropdown">
  <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
    Articles
     
    <span class="caret"></span>
  </a>
  <ul class="dropdown-menu" role="menu">
    <li>
      <a href="../articles/complex_heatmap.html">UNKNOWN TITLE</a>
    </li>
    <li>
      <a href="../articles/most_probably_asked_questions.html">UNKNOWN TITLE</a>
    </li>
  </ul>
</li>
      </ul>
      
      <ul class="nav navbar-nav navbar-right">
        <li>
  <a href="https://github.com/jokergoo/ComplexHeatmap">
    <span class="fab fa fab fa-github fa-lg"></span>
     
  </a>
</li>
      </ul>
      
    </div><!--/.nav-collapse -->
  </div><!--/.container -->
</div><!--/.navbar -->

      

      </header>

<div class="row">
  <div class="col-md-9 contents">
    <div class="page-header">
    <h1>Draw the Dendrogram</h1>
    
    <div class="hidden name"><code>grid.dendrogram.rd</code></div>
    </div>

    <div class="ref-description">
    
    <p>Draw the Dendrogram</p>
    
    </div>

    <pre class="usage"><span class='fu'><a href='grid.dendrogram.rd.html'>grid.dendrogram</a></span>(<span class='no'>dend</span>, <span class='no'>...</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='fl'>FALSE</span>)</pre>
    
    <h2 class="hasAnchor" id="arguments"><a class="anchor" href="#arguments"></a>Arguments</h2>
    <table class="ref-arguments">
    <colgroup><col class="name" /><col class="desc" /></colgroup>
    <tr>
      <th>dend</th>
      <td><p>A <code><a href='https://rdrr.io/r/stats/dendrogram.html'>dendrogram</a></code> object.</p></td>
    </tr>
    <tr>
      <th>...</th>
      <td><p>Pass to <code><a href='dendrogramGrob.rd.html'>dendrogramGrob</a></code>.</p></td>
    </tr>
    <tr>
      <th>test</th>
      <td><p>Is it in test mode? If it is in test mode, a viewport is created by calculating proper xlim and ylim.</p></td>
    </tr>
    </table>
    
    <h2 class="hasAnchor" id="details"><a class="anchor" href="#details"></a>Details</h2>

    <p><code><a href='grid.dendrogram.rd.html'>grid.dendrogram</a></code> supports drawing dendrograms with self-defind leaf positions. The positions
of leaves can be defined by <code><a href='adjust_dend_by_x.rd.html'>adjust_dend_by_x</a></code>. Also the dendrogram can be customized by setting
the <code>edgePar</code> attribute for each node (basically for controlling the style of segments), e.g.
by <code><a href='https://rdrr.io/pkg/dendextend/man/color_branches.html'>color_branches</a></code>.</p>
<p>To draw the dendrogram, a viewport should be firstly created. <code><a href='dend_xy.rd.html'>dend_xy</a></code> can be used to get the 
positions of leaves and height of the dendrogram.</p>
    

    <h2 class="hasAnchor" id="examples"><a class="anchor" href="#examples"></a>Examples</h2>
    <pre class="examples"><div class='input'><span class='no'>m</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/matrix.html'>matrix</a></span>(<span class='fu'><a href='https://rdrr.io/r/stats/Normal.html'>rnorm</a></span>(<span class='fl'>100</span>), <span class='fl'>10</span>)
<span class='no'>dend</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/stats/dendrogram.html'>as.dendrogram</a></span>(<span class='fu'><a href='https://rdrr.io/r/stats/hclust.html'>hclust</a></span>(<span class='fu'><a href='https://rdrr.io/r/stats/dist.html'>dist</a></span>(<span class='no'>m</span>)))
<span class='fu'>grid.newpage</span>()
<span class='fu'>pushViewport</span>(<span class='fu'>viewport</span>(<span class='kw'>xscale</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='fl'>0</span>, <span class='fl'>10.5</span>), <span class='kw'>yscale</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='fl'>0</span>, <span class='fu'><a href='dend_heights.rd.html'>dend_heights</a></span>(<span class='no'>dend</span>)),
    <span class='kw'>width</span> <span class='kw'>=</span> <span class='fl'>0.9</span>, <span class='kw'>height</span> <span class='kw'>=</span> <span class='fl'>0.9</span>))</div><div class='input'><span class='fu'><a href='grid.dendrogram.rd.html'>grid.dendrogram</a></span>(<span class='no'>dend</span>)</div><div class='input'><span class='fu'>popViewport</span>()</div><div class='img'><img src='grid.dendrogram-1.png' alt='' width='700' height='433' /></div><div class='input'>
<span class='fu'><a href='grid.dendrogram.rd.html'>grid.dendrogram</a></span>(<span class='no'>dend</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='fl'>TRUE</span>)</div><div class='img'><img src='grid.dendrogram-2.png' alt='' width='700' height='433' /></div><div class='input'>
<span class='fu'><a href='https://rdrr.io/r/base/library.html'>require</a></span>(<span class='no'>dendextend</span>)</div><div class='output co'>#&gt; <span class='message'>Loading required package: dendextend</span></div><div class='output co'>#&gt; <span class='message'></span>
#&gt; <span class='message'>---------------------</span>
#&gt; <span class='message'>Welcome to dendextend version 1.12.0</span>
#&gt; <span class='message'>Type citation('dendextend') for how to cite the package.</span>
#&gt; <span class='message'></span>
#&gt; <span class='message'>Type browseVignettes(package = 'dendextend') for the package vignette.</span>
#&gt; <span class='message'>The github page is: https://github.com/talgalili/dendextend/</span>
#&gt; <span class='message'></span>
#&gt; <span class='message'>Suggestions and bug-reports can be submitted at: https://github.com/talgalili/dendextend/issues</span>
#&gt; <span class='message'>Or contact: &lt;tal.galili@gmail.com&gt;</span>
#&gt; <span class='message'></span>
#&gt; <span class='message'>	To suppress this message use:  suppressPackageStartupMessages(library(dendextend))</span>
#&gt; <span class='message'>---------------------</span></div><div class='output co'>#&gt; <span class='message'></span>
#&gt; <span class='message'>Attaching package: ‘dendextend’</span></div><div class='output co'>#&gt; <span class='message'>The following object is masked from ‘package:stats’:</span>
#&gt; <span class='message'></span>
#&gt; <span class='message'>    cutree</span></div><div class='input'><span class='no'>dend</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/pkg/dendextend/man/color_branches.html'>color_branches</a></span>(<span class='no'>dend</span>, <span class='kw'>k</span> <span class='kw'>=</span> <span class='fl'>2</span>)
<span class='no'>dend</span> <span class='kw'>=</span> <span class='fu'><a href='adjust_dend_by_x.rd.html'>adjust_dend_by_x</a></span>(<span class='no'>dend</span>, <span class='fu'>unit</span>(<span class='fu'><a href='https://rdrr.io/r/base/sort.html'>sort</a></span>(<span class='fu'><a href='https://rdrr.io/r/stats/Uniform.html'>runif</a></span>(<span class='fl'>10</span>)*<span class='fl'>10</span>), <span class='st'>"cm"</span>))
<span class='fu'><a href='grid.dendrogram.rd.html'>grid.dendrogram</a></span>(<span class='no'>dend</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='fl'>TRUE</span>)</div><div class='img'><img src='grid.dendrogram-3.png' alt='' width='700' height='433' /></div></pre>
  </div>
  <div class="col-md-3 hidden-xs hidden-sm" id="sidebar">
    <h2>Contents</h2>
    <ul class="nav nav-pills nav-stacked">
      <li><a href="#arguments">Arguments</a></li>
      
      <li><a href="#details">Details</a></li>
      
      <li><a href="#examples">Examples</a></li>
    </ul>

  </div>
</div>


      <footer>
      <div class="copyright">
  <p>Developed by Zuguang Gu.</p>
</div>

<div class="pkgdown">
  <p>Site built with <a href="https://pkgdown.r-lib.org/">pkgdown</a> 1.4.1.</p>
</div>

      </footer>
   </div>

  


  </body>
</html>


