<!-- Generated by pkgdown: do not edit by hand -->
<!DOCTYPE html>
<html lang="en">
  <head>
  <meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Simple Annotation — anno_simple • ComplexHeatmap</title>

<!-- jquery -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<!-- Bootstrap -->

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha256-916EbMg70RQy9LHiGkXzG8hSg9EdNy97GazNG/aiY1w=" crossorigin="anonymous" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha256-U5ZEeKfGNOja007MMD3YBI0A3OSZOQbeG6z2f2Y0hu8=" crossorigin="anonymous"></script>

<!-- Font Awesome icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/all.min.css" integrity="sha256-nAmazAk6vS34Xqo0BSrTb+abbtFlgsFK7NKSi6o7Y78=" crossorigin="anonymous" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/v4-shims.min.css" integrity="sha256-6qHlizsOWFskGlwVOKuns+D1nB6ssZrHQrNj1wGplHc=" crossorigin="anonymous" />

<!-- clipboard.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.4/clipboard.min.js" integrity="sha256-FiZwavyI2V6+EXO1U+xzLG3IKldpiTFf3153ea9zikQ=" crossorigin="anonymous"></script>

<!-- headroom.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/headroom.min.js" integrity="sha256-DJFC1kqIhelURkuza0AvYal5RxMtpzLjFhsnVIeuk+U=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/jQuery.headroom.min.js" integrity="sha256-ZX/yNShbjqsohH1k95liqY9Gd8uOiE1S4vZc+9KQ1K4=" crossorigin="anonymous"></script>

<!-- pkgdown -->
<link href="../pkgdown.css" rel="stylesheet">
<script src="../pkgdown.js"></script>



<meta property="og:title" content="Simple Annotation — anno_simple" />

<meta property="og:description" content="Simple Annotation" />
<meta name="twitter:card" content="summary" />



<!-- mathjax -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/MathJax.js" integrity="sha256-nvJJv9wWKEm88qvoQl9ekL2J+k/RWIsaSScxxlsrv8k=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/config/TeX-AMS-MML_HTMLorMML.js" integrity="sha256-84DKXVJXs0/F8OTMzX4UR909+jtl4G7SPypPavF+GfA=" crossorigin="anonymous"></script>

<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->



  </head>

  <body>
    <div class="container template-reference-topic">
      <header>
      <div class="navbar navbar-default navbar-fixed-top" role="navigation">
  <div class="container">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <span class="navbar-brand">
        <a class="navbar-link" href="../index.html">ComplexHeatmap</a>
        <span class="version label label-default" data-toggle="tooltip" data-placement="bottom" title="Released version">2.1.0</span>
      </span>
    </div>

    <div id="navbar" class="navbar-collapse collapse">
      <ul class="nav navbar-nav">
        <li>
  <a href="../index.html">
    <span class="fas fa fas fa-home fa-lg"></span>
     
  </a>
</li>
<li>
  <a href="../reference/index.html">Reference</a>
</li>
<li class="dropdown">
  <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
    Articles
     
    <span class="caret"></span>
  </a>
  <ul class="dropdown-menu" role="menu">
    <li>
      <a href="../articles/complex_heatmap.html">UNKNOWN TITLE</a>
    </li>
    <li>
      <a href="../articles/most_probably_asked_questions.html">UNKNOWN TITLE</a>
    </li>
  </ul>
</li>
      </ul>
      
      <ul class="nav navbar-nav navbar-right">
        <li>
  <a href="https://github.com/jokergoo/ComplexHeatmap">
    <span class="fab fa fab fa-github fa-lg"></span>
     
  </a>
</li>
      </ul>
      
    </div><!--/.nav-collapse -->
  </div><!--/.container -->
</div><!--/.navbar -->

      

      </header>

<div class="row">
  <div class="col-md-9 contents">
    <div class="page-header">
    <h1>Simple Annotation</h1>
    
    <div class="hidden name"><code>anno_simple.rd</code></div>
    </div>

    <div class="ref-description">
    
    <p>Simple Annotation</p>
    
    </div>

    <pre class="usage"><span class='fu'><a href='anno_simple.rd.html'>anno_simple</a></span>(<span class='no'>x</span>, <span class='no'>col</span>, <span class='kw'>na_col</span> <span class='kw'>=</span> <span class='st'>"grey"</span>,
    <span class='kw'>which</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='st'>"column"</span>, <span class='st'>"row"</span>), <span class='kw'>border</span> <span class='kw'>=</span> <span class='fl'>FALSE</span>, <span class='kw'>gp</span> <span class='kw'>=</span> <span class='fu'>gpar</span>(<span class='kw'>col</span> <span class='kw'>=</span> <span class='fl'>NA</span>),
    <span class='kw'>pch</span> <span class='kw'>=</span> <span class='kw'>NULL</span>, <span class='kw'>pt_size</span> <span class='kw'>=</span> <span class='fu'>unit</span>(<span class='fl'>1</span>, <span class='st'>"snpc"</span>)*<span class='fl'>0.8</span>, <span class='kw'>pt_gp</span> <span class='kw'>=</span> <span class='fu'>gpar</span>(),
    <span class='kw'>simple_anno_size</span> <span class='kw'>=</span> <span class='no'>ht_opt</span>$<span class='no'>simple_anno_size</span>,
    <span class='kw'>width</span> <span class='kw'>=</span> <span class='kw'>NULL</span>, <span class='kw'>height</span> <span class='kw'>=</span> <span class='kw'>NULL</span>)</pre>
    
    <h2 class="hasAnchor" id="arguments"><a class="anchor" href="#arguments"></a>Arguments</h2>
    <table class="ref-arguments">
    <colgroup><col class="name" /><col class="desc" /></colgroup>
    <tr>
      <th>x</th>
      <td><p>The value vector. The value can be a vector or a matrix. The length of the vector or the nrow of the matrix is taken as the number of the observations of the annotation. The value can be numeric or character and NA value is allowed.</p></td>
    </tr>
    <tr>
      <th>col</th>
      <td><p>Color that maps to <code>x</code>. If <code>x</code> is numeric and needs a continuous mapping, <code>col</code>  should be a color mapping function which accepts a vector of values and returns a vector of colors. Normally it is generated by <code><a href='https://rdrr.io/pkg/circlize/man/colorRamp2.html'>colorRamp2</a></code>. If <code>x</code> is discrete (numeric or character) and needs a discrete color mapping, <code>col</code> should be a vector of  colors with levels in <code>x</code> as vector names. If <code>col</code> is not specified, the color mapping is randomly generated by <code>ComplexHeatmap:::default_col</code>.</p></td>
    </tr>
    <tr>
      <th>na_col</th>
      <td><p>Color for NA value.</p></td>
    </tr>
    <tr>
      <th>which</th>
      <td><p>Whether it is a column annotation or a row annotation?</p></td>
    </tr>
    <tr>
      <th>border</th>
      <td><p>Wether draw borders of the annotation region?</p></td>
    </tr>
    <tr>
      <th>gp</th>
      <td><p>Graphic parameters for grid borders. The <code>fill</code> parameter is disabled.</p></td>
    </tr>
    <tr>
      <th>pch</th>
      <td><p>Points/symbols that are added on top of the annotation grids. The value can be numeric or single letters. It can be a vector if <code>x</code> is a vector and a matrix if <code>x</code> is a matrix. No points are drawn if the corresponding values are NA.</p></td>
    </tr>
    <tr>
      <th>pt_size</th>
      <td><p>Size of the points/symbols. It should be a <code><a href='https://rdrr.io/r/grid/unit.html'>unit</a></code> object. If <code>x</code> is a vector, the value of <code>pt_size</code> can be a vector, while if <code>x</code> is a matrix, <code>pt_size</code> can only be a single value.</p></td>
    </tr>
    <tr>
      <th>pt_gp</th>
      <td><p>Graphic parameters for points/symbols. The length setting is same as <code>pt_size</code>. If <code>pch</code> is set as letters, the fontsize should be set as <code>pt_gp = gpar(fontsize = ...)</code>.</p></td>
    </tr>
    <tr>
      <th>simple_anno_size</th>
      <td><p>size of the simple annotation.</p></td>
    </tr>
    <tr>
      <th>width</th>
      <td><p>Width of the annotation. The value should be an absolute unit. Width is not allowed to be set for column annotation.</p></td>
    </tr>
    <tr>
      <th>height</th>
      <td><p>Height of the annotation. The value should be an absolute unit. Height is not allowed to be set for row annotation.</p></td>
    </tr>
    </table>
    
    <h2 class="hasAnchor" id="details"><a class="anchor" href="#details"></a>Details</h2>

    <p>The "simple annotation" is the most widely used annotation type which is heatmap-like, where
the grid colors correspond to the values. <code><a href='anno_simple.rd.html'>anno_simple</a></code> also supports to add points/symbols
on top of the grids where the it can be normal point (when <code>pch</code> is set as numbers) or letters (when
<code>pch</code> is set as single letters).</p>
    
    <h2 class="hasAnchor" id="value"><a class="anchor" href="#value"></a>Value</h2>

    <p>An annotation function which can be used in <code><a href='HeatmapAnnotation.rd.html'>HeatmapAnnotation</a></code>.</p>
    
    <h2 class="hasAnchor" id="see-also"><a class="anchor" href="#see-also"></a>See also</h2>

    <div class='dont-index'><p><a href='https://jokergoo.github.io/ComplexHeatmap-reference/book/heatmap-annotations.html#simple-annotation-as-an-annotation-function'>https://jokergoo.github.io/ComplexHeatmap-reference/book/heatmap-annotations.html#simple-annotation-as-an-annotation-function</a></p></div>
    

    <h2 class="hasAnchor" id="examples"><a class="anchor" href="#examples"></a>Examples</h2>
    <pre class="examples"><div class='input'><span class='no'>anno</span> <span class='kw'>=</span> <span class='fu'><a href='anno_simple.rd.html'>anno_simple</a></span>(<span class='fl'>1</span>:<span class='fl'>10</span>)
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>anno</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"a numeric vector"</span>)</div><div class='img'><img src='anno_simple-1.png' alt='' width='700' height='433' /></div><div class='input'>
<span class='no'>anno</span> <span class='kw'>=</span> <span class='fu'><a href='anno_simple.rd.html'>anno_simple</a></span>(<span class='fu'><a href='https://rdrr.io/r/base/cbind.html'>cbind</a></span>(<span class='fl'>1</span>:<span class='fl'>10</span>, <span class='fl'>10</span>:<span class='fl'>1</span>))
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>anno</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"a matrix"</span>)</div><div class='img'><img src='anno_simple-2.png' alt='' width='700' height='433' /></div><div class='input'>
<span class='no'>anno</span> <span class='kw'>=</span> <span class='fu'><a href='anno_simple.rd.html'>anno_simple</a></span>(<span class='fl'>1</span>:<span class='fl'>10</span>, <span class='kw'>pch</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='fl'>1</span>:<span class='fl'>4</span>, <span class='fl'>NA</span>, <span class='fl'>6</span>:<span class='fl'>8</span>, <span class='fl'>NA</span>, <span class='fl'>10</span>))
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>anno</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"pch has NA values"</span>)</div><div class='img'><img src='anno_simple-3.png' alt='' width='700' height='433' /></div><div class='input'>
<span class='no'>anno</span> <span class='kw'>=</span> <span class='fu'><a href='anno_simple.rd.html'>anno_simple</a></span>(<span class='fl'>1</span>:<span class='fl'>10</span>, <span class='kw'>pch</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='fu'><a href='https://rdrr.io/r/base/rep.html'>rep</a></span>(<span class='st'>"A"</span>, <span class='fl'>5</span>), <span class='fu'><a href='https://rdrr.io/r/base/rep.html'>rep</a></span>(<span class='fl'>NA</span>, <span class='fl'>5</span>)))
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>anno</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"pch has NA values"</span>)</div><div class='img'><img src='anno_simple-4.png' alt='' width='700' height='433' /></div><div class='input'>
<span class='no'>pch</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/matrix.html'>matrix</a></span>(<span class='fl'>1</span>:<span class='fl'>20</span>, <span class='kw'>nc</span> <span class='kw'>=</span> <span class='fl'>2</span>)
<span class='no'>pch</span>[<span class='fu'><a href='https://rdrr.io/r/base/sample.html'>sample</a></span>(<span class='fu'><a href='https://rdrr.io/r/base/length.html'>length</a></span>(<span class='no'>pch</span>), <span class='fl'>10</span>)] <span class='kw'>=</span> <span class='fl'>NA</span>
<span class='no'>anno</span> <span class='kw'>=</span> <span class='fu'><a href='anno_simple.rd.html'>anno_simple</a></span>(<span class='fu'><a href='https://rdrr.io/r/base/cbind.html'>cbind</a></span>(<span class='fl'>1</span>:<span class='fl'>10</span>, <span class='fl'>10</span>:<span class='fl'>1</span>), <span class='kw'>pch</span> <span class='kw'>=</span> <span class='no'>pch</span>)
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>anno</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"matrix, pch is a matrix with NA values"</span>)</div><div class='img'><img src='anno_simple-5.png' alt='' width='700' height='433' /></div></pre>
  </div>
  <div class="col-md-3 hidden-xs hidden-sm" id="sidebar">
    <h2>Contents</h2>
    <ul class="nav nav-pills nav-stacked">
      <li><a href="#arguments">Arguments</a></li>
      
      <li><a href="#details">Details</a></li>

      <li><a href="#value">Value</a></li>

      <li><a href="#see-also">See also</a></li>
      
      <li><a href="#examples">Examples</a></li>
    </ul>

  </div>
</div>


      <footer>
      <div class="copyright">
  <p>Developed by Zuguang Gu.</p>
</div>

<div class="pkgdown">
  <p>Site built with <a href="https://pkgdown.r-lib.org/">pkgdown</a> 1.4.1.</p>
</div>

      </footer>
   </div>

  


  </body>
</html>


